/** -*- mode: C++ -*-
 * weights.h contains the per-piece weighting matrices
 *
 * Copyright 1999 Colin P. Adams
 *
 * Email: colin@colina.demon.co.uk
 *  
 *   This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

const int lion1Weights[12][12] = {
  {  70,  80, 135, 180, 215, 300, 300, 250, 240, 230, 175, 160},  // final rank
  {  87,  90, 145, 190, 250, 350, 350, 345, 330, 235, 200, 170},
  {  88, 135, 185, 220, 350, 390, 380, 365, 340, 240, 230, 175},
  {  85,  90, 150, 200, 210, 230, 240, 245, 235, 230, 180,  88},
  {  70,  86, 100, 110, 120, 152, 160, 155, 152, 151,  90,  75},
  {  50,  60,  50,  76,  80,  90, 100,  95,  86,  80,  70,  55},
  {  35,  45,  55,  70,  75, 150, 151,  85,  75,  65,  55,  40},
  {  20,  35,  45,  55,  35,  70,  75,  70,  60,  50,  40,  25},
  {-100, -80, -50,  12,   5,-210,  20,  12,   5, -40, -65, -85},
  {-300,-250,-150,-100, -10,   0,   0,  -5, -95,-145,-235,-275},
  {-400,-350,-300,-250,-200,-150,-155,-205,-255,-305,-355,-405},
  {-500,-450,-400,-350,-300,-300,-300,-305,-355,-405,-455,-505}   // Drunk Elephant's rank and side
}; 
const int lion2Weights[12][12] = {
  {  70,  80, 135, 180, 215, 300, 300, 250, 240, 230, 175, 160},  // final rank
  {  87,  90, 145, 190, 250, 350, 350, 345, 330, 235, 200, 170},
  {  88, 135, 185, 220, 350, 390, 380, 365, 340, 240, 230, 175},
  {  85,  90, 150, 200, 210, 230, 240, 245, 235, 230, 180,  88},
  {  70,  86, 100, 110, 120, 152, 160, 155, 152, 151,  90,  75},
  {  50,  60,  50,  76,  80,  90, 100,  95,  86,  80,  70,  55},
  {  35,  45, 120,  70, 151, 150,  80,  85, 110, 134,  55,  40},
  {  20,  35,  45,  55,  35,  75,  40,  70,  60,  50,  40,  25},
  {-100, -80, -50,  12,   5,  10,  20,  76,   5, -40, -65, -85},
  {-300,-250,-150,-100, -10,   0,   0,  -5, -95,-145,-235,-275},
  {-400,-350,-300,-250,-200,   0,   0,-205,-255,-305,-355,-405},
  {-500,-450,-400,-350,-300,-300,-300,-305,-355,-405,-455,-505}   // Drunk Elephant's rank and side
}; 
const int lion3Weights[12][12] = {
  {  70,  80, 135, 180, 215, 300, 300, 250, 240, 230, 175, 160},  // final rank
  {  87,  90, 145, 190, 250, 350, 350, 345, 330, 235, 200, 170},
  {  88, 135, 185, 220, 350, 390, 380, 365, 340, 240, 230, 175},
  {  85,  90, 150, 200, 210, 230, 240, 245, 235, 230, 180,  88},
  {  70,  86, 100, 110, 120, 152, 160, 155, 152, 151,  90,  75},
  {  50,  60,  50,  76,  80,  90, 100,  95,  86,  80,  70,  55},
  {  35,  80, 133,  90,  95, 150, 151,  85,  75, 134,  55,  40},
  {  20,  35,  45,  55,  35,  77,  72,  70,  60,  50,  40,  25},
  {-100, -80, -50,  12,  75,  10,  20,  76,   5, -40, -65, -85},
  {-300,-250,-150,-100, -10,   0,   0,  -5, -95,-145,-235,-275},
  {-400,-350,-300,-250,-200,   0,   0,-205,-255,-305,-355,-405},
  {-500,-450,-400,-350,-300,-300,-300,-305,-355,-405,-455,-505}   // Drunk Elephant's rank and side
}; 
const int lion4Weights[12][12] = {
  {  70,  80, 100, 110, 112, 115, 120, 125, 130, 140, 175, 150},  // final rank
  {  87,  90, 110, 112, 115, 120, 125, 130, 140, 200, 180, 170},
  {  88, 114, 115, 120, 150, 163, 167, 172, 181, 190, 188, 175},
  {  85,  90, 110, 111, 121, 160, 164, 168, 175, 185, 180, 132},
  {  70,  86, 100, 110, 120, 152, 160, 165, 170, 175, 150, 135},
  {  50,  60,  50,  76,  80,  90, 100, 101, 110, 135, 136, 130},
  {  35,  80, 133,  90,  95, 150, 151,  85,  75, 134,  55,  40},
  {  20,  35,  45,  55,  35,  77,  72,  70,  60,  50,  40,  25},
  {-100, -80, -50,  12,  75,  10,  20,  76,   5, -40, -65, -85},
  {-300,-250,-150,-100, -10,   0,   0,  -5, -95,-145,-235,-275},
  {-400,-350,-300,-250,-200,   0,   0,-205,-255,-305,-355,-405},
  {-500,-450,-400,-350,-300,-300,-300,-305,-355,-405,-455,-505}   // Drunk Elephant's rank and side
}; 
const static int phoenixWeights[12][12] = {
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},  // final rank
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  { 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220},
  { 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200},
  {   0,   0,  86,  87,   0,   0,  88,  92,   0,   0,   0,   0},
  {   0,   0,  74,  73,   0,   0,  74,  73,   0,   0,   0,   0},
  {   0,   0,   0,   0,  73,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,  74,  70,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}   // Drunk Elephant's rank and side
}; 
const static int pawnWeights[9][12] = {
  { 141, 141, 141, 141, 141, 141, 141, 141, 141, 141, 141, 141},  // final rank
  { 121, 121, 121, 121, 121, 121, 121, 121, 121, 121, 121, 121},
  { 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101},
  { 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100},
  {  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90},
  {  10,  12,  12,  12,  13,  13,  13,  13,  12,  12,  12,  10},
  {   9,  11,  11,  11,  12,  12,  12,  12,  11,  11,  11,   9},
  {  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10},
  {  -9,  -8, -50, -50, -55, -35, -30, -54, -50, -50,  -8,  -9},  // initial pawn rank
}; 
const static int kylinWeights[12][12] = {
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},  // final rank
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0, 800,   0, 800,   0, 800,   0, 800,   0, 800,   0, 800},
  { 350,   0, 350,   0, 350,   0, 350,   0, 350,   0, 350,   0},
  {   0,  23,   0,  22,   0,  22,   0,  22,   0,  23,   0,  22},
  {  21,   0,  21,   0,  21,   0,  21,   0,  21,   0,  21,   0},
  {   0,  19,   0,   0,   0,  20,   0,  19,   0,  19,   0,  19},
  {   0,   0,   2,   0,   0,   0,   0,   0,   4,   0,   0,   0},
  {   0,   0,   0,   1,   0,   0,   0,  10,   0,   2,   0,   0},
  {   0,   0,   0,   0,  20,   0,   0,   0,   0,   0,   0,   0}   // Drunk Elephant's rank and side
}; 
const static int sideWeights[12][12] = {
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},  // final rank
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}   // Drunk Elephant's rank and side
};
const static int elephantWeights[12][12] = {
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},  // final rank
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   14,  0,   0,   0,   0,   0,   0},
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}   // Drunk Elephant's rank and side
}; 
const static int copperWeights[12][12] = {
  { 200, 204, 205, 210, 220, 225, 225, 220, 210, 205, 204, 200},  // final rank
  { 206, 208, 215, 225, 230, 235, 235, 230, 225, 215, 208, 206},
  { 203, 205, 210, 220, 225, 230, 230, 225, 220, 210, 205, 203},
  { 201, 203, 205, 208, 210, 220, 220, 210, 209, 207, 204, 201},
  { 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200},
  { 160, 165, 170, 175, 180, 181, 181, 180, 176, 171, 166, 160},
  {  40,  60,  60,  80,  90,  95,  95,  91,  80,  62,  62,  40},
  {  34,  58,  56,  70,  81,  85,  85,  81,  72,  58,  60,  34},
  {  25,  35,  35,  60,  75,  80,  80,  75,  60,  35,  35,  25},
  {  10,  20,  30,  50,  50,  60,  60,  50,  50,  30,  30,  10},
  {   0,  20,  20,  29,  20,  40,  40,  20,  29,  20,  20,   0},
  { -20, -10,   0,   0,   0,   0,   0,   0,   0,   0, -10, -20}   // Drunk Elephant's rank and side
}; 
const static int silverWeights[12][12] = {
  { 200, 204, 205, 210, 220, 225, 225, 220, 210, 205, 204, 200},  // final rank
  { 206, 208, 215, 225, 230, 235, 235, 230, 225, 215, 208, 206},
  { 203, 205, 210, 220, 225, 230, 230, 225, 220, 210, 205, 203},
  { 201, 203, 205, 208, 210, 220, 220, 210, 209, 207, 204, 201},
  { 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200},
  { 160, 165, 170, 175, 180, 181, 181, 180, 176, 171, 166, 160},
  {  40,  60,  60,  80,  95,  90,  90,  96,  80,  62,  62,  40},
  {  34,  58,  56,  70,  85,  81,  81,  85,  72,  58,  60,  34},
  {  25,  35,  35,  60,  75,  80,  80,  75,  60,  35,  35,  25},
  {  10,  20,  30,  50,  50,  60,  60,  50,  50,  30,  30,  10},
  {   0,  20,  20,  28,  20,  40,  40,  20,  28,  20,  20,   0},
  { -20, -10,   0,   0,   0,   0,   0,   0,   0,   0, -10, -20}   // Drunk Elephant's rank and side
}; 
const static int leopardWeights[12][12] = {
  { 200, 204, 205, 210, 220, 225, 225, 220, 210, 205, 204, 200},  // final rank
  { 206, 208, 215, 225, 230, 235, 235, 230, 225, 215, 208, 206},
  { 203, 205, 210, 220, 225, 230, 230, 225, 220, 210, 205, 203},
  { 201, 203, 205, 208, 210, 220, 220, 210, 209, 207, 204, 201},
  { 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200},
  { 160, 165, 170, 175, 180, 181, 181, 180, 176, 171, 166, 160},
  {  40,  60,  60,  80,  95,  90,  90,  96,  80,  62,  62,  40},
  {  34,  58,  56,  70,  85,  81,  81,  85,  72,  58,  60,  34},
  {  25,  35,  35,  60,  75,  80,  80,  75,  60,  35,  35,  25},
  {  10,  20,  30,  31,  50,  60,  60,  50,  31,  30,  30,  10},
  {   0,   8,   8,  28,  20,  40,  40,  20,  28,   8,   8,   0},
  { -20,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, -20}   // Drunk Elephant's rank and side
}; 
const static int horseWeights[12][12] = {
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58}, 
  {  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58}, 
  {  57,  58,  58,  58,  57,  57,  57,  57,  58,  58,  58,  57}, 
  {  57,  59,  58,  58,  57,  57,  57,  57,  58,  58,  59,  57}, 
  {  56,  58,  57,  58,  49,  49,  49,  49,  58,  57,  58,  56}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}   // Drunk Elephant's rank and side
}; 
const static int dragonWeights[12][12] = {
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,  15,   0,  15,  15,   0,  15,   0,   0,   0}, 
  {  30,  30,  20,   0,   0,   0,   0,   0,   0,  20,  30,  50}   // Drunk Elephant's rank and side
}; 
const static int goldWeights[12][12] = {
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   5,   6,   3,   3,   0,   5,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}   // Drunk Elephant's rank and side
}; 
const static int  tigerWeights[12][12] = {
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0}, 
  {   0,   0,   0,   0,   4,   0,   4,   0,   0,   0,   0,   0}   // Drunk Elephant's rank and side
}; 
