#ifdef __cplusplus
extern "C" {
#endif
/*
ANSI C code generated by SmallEiffel The GNU Eiffel Compiler
Release -0.76 (Saturday 11th november 2000)
Copyright (C), 1994-2000 - LORIA - UHP - CRIN - INRIA - FRANCE
Dominique COLNET and Suzanne COLLIN - colnet@loria.fr
http://SmallEiffel.loria.fr
*/

/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://SmallEiffel.loria.fr
--
*/
/*
  This file (SmallEiffel/sys/runtime/base.h) contains all basic Eiffel
  type definitions.
  This file is automatically included in the header for all modes of 
  compilation : -boost, -no_check, -require_check, -ensure_check, ...
  This file is also included in the header of any cecil file (when the
  -cecil option is used).
  This file is also included in the header file of C++ wrappers (when
  using the external "C++" clause).
*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifdef WIN32
#include <windows.h>
#else
#ifndef O_RDONLY
#include <sys/file.h>
#endif
#ifndef O_RDONLY
#define O_RDONLY 0000
#endif
#endif

/*
  Because ANSI C EXIT_FAILURE is not always defined :
 */
#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif

/* 
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.
*/
#ifdef _SIGSET_H_types
#define JMP_BUF    sigjmp_buf
#define SETJMP(x)  sigsetjmp( (x), 1)
#define LONGJMP    siglongjmp
#else
#define JMP_BUF    jmp_buf
#define SETJMP(x)  setjmp( (x) )
#define LONGJMP    longjmp
#endif

/* 
   Type to store reference objects Id :
 */
typedef int Tid;

typedef struct S0 T0;

struct S0{
  Tid id;
};

/* 
   The default channel used to print runtime error messages :
*/
#define SE_ERR stderr

/* 
   Eiffel type INTEGER is #2 :
*/
typedef int T2;
#define EIF_INTEGER T2
#define M2 (0)
#define EIF_INTEGER_BITS (CHAR_BIT*sizeof(int))
#define EIF_MINIMUM_INTEGER (INT_MIN)
#define EIF_MAXIMUM_INTEGER (INT_MAX)

/*
  Eiffel type CHARACTER is #3 :
*/
typedef unsigned char T3;
#define EIF_CHARACTER T3
#define M3 (0)
#define EIF_CHARACTER_BITS (CHAR_BIT)
#define EIF_MINIMUM_CHARACTER_CODE (0)
#define EIF_MAXIMUM_CHARACTER_CODE (255)
#define T3code(x) ((T2)(x))
#define T3to_integer(x) ((T2)((char)(x)))
#define T3to_bit(x) (x)

/*
  Eiffel type REAL is #4 :
*/
typedef float T4;
#define EIF_REAL T4
#define M4 (0.0)
#define EIF_REAL_BITS (CHAR_BIT*sizeof(float))
#define EIF_MINIMUM_REAL (-(FLT_MAX))
#define EIF_MAXIMUM_REAL (FLT_MAX)
#define T2toT4(x) ((T4)(x))

/*
  Eiffel type DOUBLE is #5 :
*/
typedef double T5;
#define EIF_DOUBLE T5
#define M5 (0.0)
#define EIF_DOUBLE_BITS (CHAR_BIT*sizeof(double))
#define EIF_MINIMUM_DOUBLE (-(DBL_MAX))
#define EIF_MAXIMUM_DOUBLE (DBL_MAX)
#define T2toT5(x) ((T5)(x))
#define T4toT5(x) ((T5)(x))

/*
  Eiffel type BOOLEAN is #6 :
*/
typedef char T6;
#define EIF_BOOLEAN T6
#define M6 (0)
#define EIF_BOOLEAN_BITS (CHAR_BIT)

/* 
   Eiffel type POINTER is #8 :
*/
typedef void* T8;
#define EIF_POINTER T8
#define M8 (NULL)
#define EIF_POINTER_BITS (CHAR_BIT*sizeof(void*))

/*
  To use type STRING on the C side :
*/
#define EIF_STRING T7*

/*
  Some Other EIF_* defined in ETL :
*/
#define eif_access(x) ((char*)(x))
#define EIF_REFERENCE T0*
#define EIF_OBJ T0*
#define EIF_OBJECT EIF_OBJ

/* 
   Wrappers for `malloc', `calloc' and `realloc' :
*/
void* se_malloc(size_t size);
void* se_calloc(size_t nmemb, size_t size);
void* se_realloc(void *ptr, size_t size);

/* --- Mangling Table Start ---
A 1  T8    E POINTER 8
A 1  T6    E BOOLEAN 6
A 1  T25   R FIXED_ARRAY[BOOLEAN] 25
A 1  T19   R PIECE 19
A 1  T3    E CHARACTER 3
A 1  T31   E NATIVE_ARRAY[BOOLEAN] 31
D    T26   R INTEGER_REF
D    T36   R POINTER_REF
D    T20   R BOOLEAN_REF
D 1  T33   R ARRAYED_COLLECTION[INTEGER] 32
A 1  T7    R STRING 7
A 1  T9    E NATIVE_ARRAY[CHARACTER] 9
A 1  T32   R FIXED_ARRAY[INTEGER] 32
A 1  T2    E INTEGER 2
A 1  T17   R TEST 17
D    T35   R CHARACTER_REF
A 1  T34   E NATIVE_ARRAY[INTEGER] 34
 --- Mangling Table End --- */

/*C Header Pass 1 :*/
typedef struct S25 T25;
typedef struct S19 T19;
typedef struct S7 T7;
typedef struct S32 T32;
typedef struct S17 T17;

/*C Header Pass 2 :*/
typedef T6*T31;
typedef T3*T9;
typedef T2*T34;

/*C Header Pass 3 :*/

/*C Header Pass 4 :*/
struct S25{Tid id;T31 _storage;T2 _capacity;T2 _upper;};
extern T25 M25;
void se_prinT25(T25**o);
struct S19{Tid id;T2 _colour;T0* _name;T0* _range;T0* _lion;T0* _jump;};
extern T19 M19;
void se_prinT19(T19**o);
void se_prinT31(T31*o);
struct S7{Tid id;T9 _storage;T2 _count;T2 _capacity;};
extern T7 M7;
void se_prinT9(T9*o);
struct S32{Tid id;T34 _storage;T2 _capacity;T2 _upper;};
extern T32 M32;
void se_prinT32(T32**o);
struct S17{Tid id;};
extern T17 M17;
void se_prinT17(T17**o);
void se_prinT34(T34*o);
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://SmallEiffel.loria.fr
--
*/
/*
  This file (SmallEiffel/sys/runtime/no_check.h) is automatically included 
  when `run_control.no_check' is true (ie. all modes except mode -boost).
*/
#define SE_NO_CHECK 1

void se_prinT0(T0**o);
void se_prinT2(EIF_INTEGER*o);
void se_prinT3(EIF_CHARACTER*o);
void se_prinT4(EIF_REAL*o);
void se_prinT5(EIF_DOUBLE*o);
void se_prinT6(EIF_BOOLEAN*o);
void se_prinT7(EIF_STRING*o);
void se_prinT8(EIF_POINTER*o);

/* 
   This type is used to store a position in some Eiffel source file.
   It must be compatible with the implementation of class POSITION.
*/
typedef unsigned int se_position;

EIF_INTEGER se_position2line(se_position position);
EIF_INTEGER se_position2column(se_position position);
EIF_INTEGER se_position2path_id(se_position position);

/*
  To be able to print a stack frame in a human readable format :
*/
typedef struct _se_frame_descriptor se_frame_descriptor;
struct _se_frame_descriptor {
  char* name;
  int use_current;
  int local_count; /* Number of C variable to print. */
  char* local_format; /* Format information. */
  int assertion_flag; /* 1 when assertions can be checked. */ 
};

/*
  To keep the track of execution in order to be able to print a 
  dump when things goes wrong :
*/
typedef struct _se_dump_stack se_dump_stack;
struct _se_dump_stack {
  se_frame_descriptor* fd;
  void** current; /* NULL when not used. */
  se_position p; /* The current position. */
  se_dump_stack* caller; /* Back to the caller. */
  void*** locals;
};
extern se_dump_stack* se_dst;
void se_print_run_time_stack(void);
void se_print_one_frame(se_dump_stack*ds);
void se_core_dump(char *msg);

extern int se_rspf;
extern int se_require_uppermost_flag;
extern int se_require_last_result;
int se_rci(void*C);
void error0(char*m,char*vv);
void error1(char*m,se_position position);
void error2(T0*o,se_position position);
T0* vc(void*o,se_position position);
T0* ci(int id,void*o,se_position position);
void ac_req(int v,char*vv);
void ac_ens(int v,char*vv);
void ac_inv(int v,char*vv);
void ac_liv(int v,char*vv);
void ac_insp(int v);
int ac_lvc(int lc,int lv1,int lv2);
void ac_civ(int v,char*vv);
void se_evobt(void*o,se_position position);
void sigrsp(int sig);
void se_gc_check_id(void*o,int id);
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://SmallEiffel.loria.fr
--
*/
/*
  This file (SmallEiffel/sys/runtime/trace.h) is automatically included when 
  `run_control.no_check' is true (ie. all modes except -boost).
  This file comes after no_check.[hc] to implements the -trace flag.
*/
#ifdef SE_WEDIT
se_position se_trace(se_position p);
#elif SE_TRACE
void se_trace(se_dump_stack*ds,se_position p);
#endif
#define FSOC_SIZE 8192
#define RSOC_SIZE 32768
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://SmallEiffel.loria.fr
--
*/
/* 
   This file (SmallEiffel/sys/runtime/gc_lib.h) is automatically included 
   when the Garbage Collector is used (default, unless option -no_gc has 
   been selected).
*/
#define SE_GC_LIB 1

#define RSOH_UNMARKED 15253     
#define RSOH_FREE 1
#define RSOH_MARKED 2


#define FSOH_UNMARKED 1
#define FSOH_MARKED 2

/* To codify the state and the type of some Memory Chunk, we are 
   using the following definitions :
*/
#define FSO_FREE_CHUNK  (-2)
#define RSO_FREE_CHUNK  (-1)
#define RSO_USED_CHUNK  ( 0)
#define FSO_STORE_CHUNK ( 1)
#define FSO_USED_CHUNK  ( 2)
#define FREE_CHUNK(x) ((x)<0)

/* Minimum size for a store area in a ReSizable Objects Chunk :
 */
#define RSOC_MIN_STORE 512

/* The default channel used to print -gc_info flag information :
*/
#define SE_GCINFO SE_ERR

typedef struct s_mch mch; /* Memory Chunk Header. */
typedef struct s_fsoc fsoc; /* Fixed Size Objects Chunk. */
typedef union u_rsoh rsoh; /* ReSizable Object Header. */
typedef struct s_fll_rsoh fll_rsoh; 
typedef struct s_rsoc rsoc; /* ReSizable Objects Chunk. */
typedef struct s_na_env na_env; /* Native Array ENVironment. */


struct s_mch{ 
  int size; /* In number of bytes (actual argument of malloc).*/
  int state_type; /* One value in : RSO_USED_CHUNK, 
                     FREE_CHUNK, FSO_STORE_CHUNK, FSO_USED_CHUNK */
  void(*amfp)(mch*,void*); /* Align Mark Function Pointer. */
  void(*swfp)(mch*); /* SWeep Function Pointer. */
};

struct s_fsoc{
  mch header;
  fsoc* next;
  int count_minus_one;
  double first_object;
};

typedef struct _rso_header rso_header;

struct _rso_header{
    int size;
    int magic_flag;     /* RSOH_MARKED when used,
			   RSOH_FREE when free,
			   else RSOH_UNMARKED */
};

union u_rsoh{
  rso_header header;             
  double padding; 
  };

struct s_fll_rsoh {
  rso_header rsoh_field;
  fll_rsoh* nextflol;
};

struct s_rsoc{
  mch header;
  rsoc* next;
  fll_rsoh*free_list_of_large;
  na_env*nae;
  rsoh first_header;
};

struct s_na_env{
  int store_left;
  rsoh* store;
  rsoc*store_chunk;
  rsoc*chunk_list;
  void (*gc_mark)(T0*);
};

extern void**stack_bottom;
extern mch**gcmt;
extern int gcmt_max;
extern int gcmt_used;
extern fsoc*fsocfl;
extern rsoc*rsocfl;
extern int gc_is_off;
extern unsigned int fsoc_count;
extern unsigned int rsoc_count;
extern void*gcmt_tail_addr;

int na_rounded_size(int s);
void gc_sweep(void);
void gc_mark(void*p);
int gc_stack_size(void);
int garbage_delayed(void);
void gc_update_ceils(void);
fsoc*new_fsoc(void);
char*new_na(na_env*nae,int size);
void gcna_align_mark(rsoc*c,void*o);
int fsocfl_count(void);
int rsocfl_count(void);
void gc_dispose_before_exit(void);
void rsocfl_info(void);
void mark_stack_and_registers (void);
extern unsigned int fsoc_count_ceil;
extern unsigned int rsoc_count_ceil;
extern unsigned int gc_start_count;
T6 r6_ix_not(se_dump_stack*caller,T6 C);
extern se_frame_descriptor f6_ix_not;
T6 r6_px_or(se_dump_stack*caller,T6 C,T6 a1);
extern se_frame_descriptor f6_px_or;
T6 r31is_not_null(se_dump_stack*caller,T31 C);
extern se_frame_descriptor f31is_not_null;
void r31clear(se_dump_stack*caller,T31 C,T2 a1,T2 a2);
extern se_frame_descriptor f31clear;
T6 r31all_default(se_dump_stack*caller,T31 C,T2 a1);
extern se_frame_descriptor f31all_default;
T6 r9is_not_null(se_dump_stack*caller,T9 C);
extern se_frame_descriptor f9is_not_null;
T6 r34is_not_null(se_dump_stack*caller,T34 C);
extern se_frame_descriptor f34is_not_null;
void r34clear(se_dump_stack*caller,T34 C,T2 a1,T2 a2);
extern se_frame_descriptor f34clear;
T6 r34all_default(se_dump_stack*caller,T34 C,T2 a1);
extern se_frame_descriptor f34all_default;
extern se_frame_descriptor se_ifd7;
T7*se_i7(se_dump_stack*caller,T7*C);
T2 r25count(se_dump_stack*caller,T25* C);
extern se_frame_descriptor f25count;
void r25make(se_dump_stack*caller,T25* C,T2 a1);
extern se_frame_descriptor f25make;
T6 r25all_default(se_dump_stack*caller,T25* C);
extern se_frame_descriptor f25all_default;
extern se_frame_descriptor se_ifd25;
T25*se_i25(se_dump_stack*caller,T25*C);
T2 r32count(se_dump_stack*caller,T32* C);
extern se_frame_descriptor f32count;
void r32make(se_dump_stack*caller,T32* C,T2 a1);
extern se_frame_descriptor f32make;
T6 r32all_default(se_dump_stack*caller,T32* C);
extern se_frame_descriptor f32all_default;
extern se_frame_descriptor se_ifd32;
T32*se_i32(se_dump_stack*caller,T32*C);
void r19make(se_dump_stack*caller,T19* C,T0* a1,T2 a2);
extern se_frame_descriptor f19make;
void r17make(se_dump_stack*caller,T17* C);
extern se_frame_descriptor f17make;
extern T17*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
#define SE_MAXID 38
extern T7* g[];
extern T7* t[];
extern char* p[];
extern void(*se_prinT[38])(void**);
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T7*ms17_13130;
T7*se_ms(int c,char*e);
T7*se_string(char*e);
void se_msi1(void);
void manifest_string_mark1(void);
void once_function_mark(void);
void gc_start(void);
typedef struct B25 gc25;
struct B25{T25 object;union {int flag;gc25*next;} header;};
extern gc25*store25;
extern int store_left25;
extern fsoc*store_chunk25;
extern gc25*gc_free25;
typedef struct B19 gc19;
struct B19{T19 object;union {int flag;gc19*next;} header;};
extern gc19*store19;
extern int store_left19;
extern fsoc*store_chunk19;
extern gc19*gc_free19;
extern na_env na_env31;
typedef struct B7 gc7;
struct B7{T7 object;union {int flag;gc7*next;} header;};
extern gc7*store7;
extern int store_left7;
extern fsoc*store_chunk7;
extern gc7*gc_free7;
extern na_env na_env9;
typedef struct B32 gc32;
struct B32{T32 object;union {int flag;gc32*next;} header;};
extern gc32*store32;
extern int store_left32;
extern fsoc*store_chunk32;
extern gc32*gc_free32;
typedef struct B17 gc17;
struct B17{T17 object;union {int flag;gc17*next;} header;};
extern gc17*store17;
extern int store_left17;
extern fsoc*store_chunk17;
extern gc17*gc_free17;
extern na_env na_env34;
void gc_sweep25(fsoc*c);
void gc_mark25(T25*o);
void gc_align_mark25(fsoc*c,gc25*p);
extern fsoc H25;
T25*new25(void);
void gc_sweep19(fsoc*c);
void gc_mark19(T19*o);
void gc_align_mark19(fsoc*c,gc19*p);
extern fsoc H19;
T19*new19(void);
void gc_mark31(T31 o);
T31 new31(int size);
void gc_sweep7(fsoc*c);
void gc_mark7(T7*o);
void gc_align_mark7(fsoc*c,gc7*p);
extern fsoc H7;
T7*new7(void);
void gc_mark9(T9 o);
T9 new9(int size);
void gc_sweep32(fsoc*c);
void gc_mark32(T32*o);
void gc_align_mark32(fsoc*c,gc32*p);
extern fsoc H32;
T32*new32(void);
void gc_sweep17(fsoc*c);
void gc_mark17(T17*o);
void gc_align_mark17(fsoc*c,gc17*p);
extern fsoc H17;
T17*new17(void);
void gc_mark34(T34 o);
T34 new34(int size);

#ifdef __cplusplus
}
#endif
