/** -*- mode: C++ -*-
 * promote.h represents a promotion to the computer player
 *
 * Copyright 1999 Colin P. Adams
 *
 * Email: colin@colina.demon.co.uk
 *  
 *   This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef PROMOTION_H 
#define PROMOTION_H

class Promotion {
  bool compulsory;
  bool promoted;
  bool promotionOK;
  bool delayedPromotion;
  jint valueChange;
public:
  Promotion() { reset(); }
  bool wasCompulsory() const { return compulsory; }
  bool wasPromoted() const { return promoted; }
  bool isOK() const { return promotionOK; }
  bool wasDelayed() const { return delayedPromotion; }
  void setCompulsory() { compulsory=true; }
  void setPromoted() { promoted=true; }
  void setDelayedPromotion() { delayedPromotion=true; }
  void setOK() { promotionOK=true; }
  void setGain(jint v) { valueChange=v; }
  void reset() { compulsory=false; promoted=false; promotionOK=false; 
  delayedPromotion=false; valueChange=0; 
  }
  jint gain() const { return valueChange; }
};

#endif
