/**
 * piece.cpp implements a lightweight piece (as used by the computer player)
 *
 * Copyright 1999 Colin P. Adams
 *
 * Email: colin@colina.demon.co.uk
 *  
 *   This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

using namespace std;

#ifdef INLINE_OK 
#define INLINE inline
#else
#define INLINE  
#endif
#include "piece.h"
#include "promotion.h"

INLINE void Piece::checkForPromotion(Promotion& promotion,const Coordinates& source, 
			      const Coordinates& target,
			      bool capture, PieceCharacteristics*const*thePieces)
{ // this is only called if the piece has a promotion

  bool sourceQualifies=false;
  bool targetQualifies=false;
  bool qualifies=false;
  jint sourceRank=source.y();
  jint targetRank=target.y();

  if (colour) { //normalise for the white side
    sourceRank=11-sourceRank;
    targetRank=11-targetRank;
  }

  sourceQualifies=(12-sourceRank) <= 4;
  targetQualifies=(12-targetRank) <= 4;
  qualifies=sourceQualifies || targetQualifies; // if true, then the move is within the zone
  bool doIt=false;
  bool compulsory=false;

  if ((targetRank == 11) && (thePiece->finalRank)) {
    doIt=true;
    qualifies=true;
    compulsory=true;
  }

  if (qualifies && !doIt && delayedPromotion && !promotionOK) { // delayed promotion rule
    bool pawn=(thePiece->type == PAWN);
    if (pawn) qualifies=false;
    else if (capture) qualifies=true;  // captures always qualify, apart from pawns
    else qualifies=false;

    if (pawn) promotion.setDelayedPromotion();
    else promotion.setOK();
  }

  if (qualifies) doIt=true;
  if (doIt) {
    jint value=thePiece->value;
    jint newValue=thePieces[thePiece->promotion]->value;
    jint gain = newValue-value;
    promotion.setGain(gain);
    if (compulsory) promotion.setCompulsory();
    promotion.setPromoted();
  }

}
