/** -*- mode: C++ -*-
 * generatedMove.h defines a generated move
 *
 * Copyright 1999 Colin P. Adams
 *
 * Email: colin@colina.demon.co.uk
 *  
 *   This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef GENERATE_MOVE_H 
#define GENERATE_MOVE_H
#include <jni.h>
#include "move.h"
#include "board.h"

class GeneratedMove {
  Move theMove;
  jint score;
  bool now;           // if set, then do not search deeper
  bool legal;
  Targets targets;
 public:
  GeneratedMove(const Move &m) : theMove(m) { 
    score=0; legal=false; now=false; }
  GeneratedMove(const Move &m, bool l) : theMove(m) { 
    score=0; legal=l; now=false; }
  GeneratedMove operator=(const GeneratedMove &gm) { 
    theMove=gm.theMove; score=gm.score; legal=gm.legal; now=gm.now; 
    targets=gm.targets;
    return *this;
  }
  bool operator==(const GeneratedMove& gm) const { // equality 
    // equality means the moves are equal, not necessarily the scores
    return (getMove() == gm.getMove());
    }


  const Move  getMove() const { return theMove; }
  bool isLegal() const { return legal; }
  bool evaluateNow() const { return now; }
  jint getValue() const { return score; }
  void setScore(jint s) { score = s; }
  void setEvaluateNow() { now=true; }
  bool updatePosition(Board&b, bool repetitions) {
    legal=b.performMove(theMove,targets, repetitions);
    if (!legal) restorePosition(b, false); // we do NOT want to remove the Forsyth that proved the
    //                                        position to be illegal 
    //b.describeBoard(); cout << endl;
    return legal;
  }

  void restorePosition(Board&b, bool repetitions) {
    b.backOutMove(theMove,targets, repetitions);
    //b.describeBoard(); cout << endl;
  }
};

#endif

