/** -*- mode: C++ -*-
 * generate.h defines a move generator
 *
 * Copyright 1999 Colin P. Adams
 *
 * Email: colin@colina.demon.co.uk
 *  
 *   This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef GENERATE_H 
#define GENERATE_H
#include <jni.h>
#include <list>
#include "board.h"
#include "generatedMove.h"
#include "promotion.h"

typedef list<pair<GeneratedMove,jint> > listType;
typedef list<Move> killerListType;

class Generator {
  static const jint KILLER_SCORE=10000; 
  Board         *homeBoard;
  const Move *previousMove;
  listType     listOfMoves;
  bool           extraDeep;
  bool       alwaysPromote;
  bool         extraDeepOK;
  jint        previousFile;
  jint        previousRank;
  killerListType  *killers;
  jint          secondGain;
  bool        generateNextMove(Promotion&, Move&, const Coordinates&, const Coordinates&);
  bool        soaringEagle(Move &);
  bool        hornedFalcon(Move &);
  bool        generateLion(Move &);
public:
  Generator(Board *,const Move*, bool, bool, killerListType*);
  void generate();
  listType &getMoves() { return listOfMoves; }
};

#endif






