/**
 * evaluate calculates the value of the position
 *
 * Copyright 1999 Colin P. Adams
 *
 * Email: colin@colina.demon.co.uk
 *  
 *   This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

using namespace std;

#ifdef INLINE_OK 
#define INLINE inline
#else
#define INLINE  
#endif
#include  "board.h"
#include  "weights.h"
#include  <jni.h>    // for machine-independent types

INLINE jint Board::evaluate(bool colour)
{

  jint value=0;

  if (getCrownPrinces(colour) == 0) value-=500000;
  else if (getCrownPrinces(colour) == 2) value+=900;
  if (getCrownPrinces(!colour) == 0) value+=500000;
  else if (getCrownPrinces(!colour) == 2) value-=900;

  // now loop over the board

  for (jint rank=0; rank < 12; rank++) 
    for (jint file=11; file >= 0; file--) {

      jint abbrev=getAbbrev(file,rank);
      if (abbrev > 0 ) {
        // we have a piece

	jint tempValue=0;
	bool pieceColour=getColour(file,rank);

        jint weightRank, weightFile;

        if (pieceColour) { // black
	  weightRank=rank;
	  weightFile=11-file;
	}
	else {
	  weightRank=11-rank;
	  weightFile=file;
	}

        tempValue=getValue(file, rank);

        switch (abbrev) {
	case LION: 
	case PrKYLIN:
	  switch (lions) {
	  case 1:
	    tempValue+=lion1Weights[weightRank][weightFile];
	    break;
	  case 2:
	    tempValue+=lion2Weights[weightRank][weightFile];
	    break;
	  case 3:
	    tempValue+=lion3Weights[weightRank][weightFile];
	    break;
	  case 4:
	    tempValue+=lion4Weights[weightRank][weightFile];
	    break;
	  }
	  break;
	case PHOENIX:
	  tempValue+=phoenixWeights[weightRank][weightFile];
	  break;
	case GOLD:
	  tempValue+=goldWeights[weightRank][weightFile];
	  break;
	case BLINDTIGER:
	  tempValue+=tigerWeights[weightRank][weightFile];
	  break;
	case DRUNKELEPHANT:
	  tempValue+=elephantWeights[weightRank][weightFile];
	  break;
	case PAWN:
	  tempValue+=pawnWeights[weightRank][weightFile];
	  break;
	case KYLIN:
	  tempValue+=kylinWeights[weightRank][weightFile];
	  break;
	case SIDEMOVER:
	  tempValue+=sideWeights[weightRank][weightFile];
	  break;
	case COPPER:
	  tempValue+=copperWeights[weightRank][weightFile];
	  break;
	case SILVER:
	  tempValue+=silverWeights[weightRank][weightFile];
	  break;
	case LEOPARD:
	  tempValue+=leopardWeights[weightRank][weightFile];
	  break;
	case HORSE:
	  tempValue+=horseWeights[weightRank][weightFile];
	  break;
	case DRAGON:
	  tempValue+=dragonWeights[weightRank][weightFile];
	  break;
	default: ;
	}

	if (pieceColour == colour) value+=tempValue;
	else value-=tempValue;

      }
    }

  return value;
}





