/**  -*- mode: C++ -*-
 * coordinates.h defines a set of board coordinates (as used by the computer player)
 *
 * Copyright 1999 Colin P. Adams
 *
 * Email: colin@colina.demon.co.uk
 *  
 *   This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef COORDINATES_H 
#define COORDINATES_H
#include <jni.h>
#include <string>
#include <strstream.h>
#include "directions.h"

class Coordinates {
  jint      X;        // the file
  jint      Y;        // the rank
 public:
  Coordinates(jint x=-1, jint y=-1) { X = x; Y = y; } //defaults are invalid
  jint x() const { return X; }
  jint y() const { return Y; }
  void reset() { X=-1; Y=-1; }
  void set(Coordinates const &c) { X = c.X; Y=c.Y; }
  void inc(Directions, jint, bool);

  void describe(char *c) const { 
    // this writes into it's argument!
    jint file = X + 1;
    char rank = char(jint('a') + Y);

    ostrstream streamBuffer(c,5);  
    streamBuffer << file << rank << ' ' << ends;

  }
  bool operator==(const Coordinates& c) const { return (c.X == X && c.Y == Y); } 
};

#endif
