/**
 * coordinates.cpp implements the board coordinates (as used by the computer player)
 *
 * Copyright 1999 Colin P. Adams
 *
 * Email: colin@colina.demon.co.uk
 *  
 *   This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

using namespace std;

#ifdef INLINE_OK 
#define INLINE inline
#else
#define INLINE  
#endif
#include "coordinates.h"

INLINE void Coordinates::inc(Directions dir, jint steps, bool normal)
{
  if (( dir == NORTH && normal ) || ( dir == SOUTH && !normal)) {
    Y = Y - steps;
  }
  else if (( dir == SOUTH && normal ) || ( dir == NORTH && !normal)) {
    Y = Y + steps;
  }
  else if (( dir == EAST && normal ) || ( dir == WEST && !normal)) {
    X = X - steps;
  }
  else if (( dir == WEST && normal ) || ( dir == EAST && !normal)) {
    X = X + steps;
  }
  else if (( dir == NORTHEAST && normal ) || ( dir == SOUTHWEST && !normal)) {
    X = X - steps;
    Y = Y - steps;
  }
  else if (( dir == SOUTHWEST && normal ) || ( dir == NORTHEAST && !normal)) {
    X = X + steps;
    Y = Y + steps;
  }
  else if (( dir == NORTHWEST && normal ) || ( dir == SOUTHEAST && !normal)) {
    X = X + steps;
    Y = Y - steps;
  }
  else if (( dir == SOUTHEAST && normal ) || ( dir == NORTHWEST && !normal)) {
    X = X - steps;
    Y = Y + steps;
  }
}
