/**
 * chuprof.cpp reads a board.data file, and calls search, for profiling.
 *
 * Copyright 1999 Colin P. Adams
 *
 * Email: colin@colina.demon.co.uk
 *  
 *   This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

using namespace std;

#include <fstream>
#include <string>
#include "piece.h"
#include "board.h"
#include "move.h"
#include "search.h"

int main()
{

  // turn these into parameters
  string fileName("board.data");
  int ply=4;
  bool extraMove=true;
  bool alwaysPromote=false;
  bool colour=true;               // black to move
  int lions=1;

  Board homeBoard(lions);             

  string pieceName;

  ifstream data(fileName.c_str());     // open the data file

  int blackPieces=0;
  int whitePieces=0;
  int blackCrownPrinces=0;
  int whiteCrownPrinces=0;

  for (jint rank=0; rank < 12; rank++)
    for (jint file=11; file >= 0; file--) {
      data >> pieceName;
    
      if (pieceName == "#") ;          // empty square
      else {
	bool colour=(pieceName[0] == 'B');

        if (colour) blackPieces++;
	else whitePieces++;

	string realName=pieceName.substr(1);  // strip the colour indicator

	PieceType type=NONE;

	if (realName == "Lance") type=LANCE;
        else if (realName == "Ferocious#Leopard") type=LEOPARD;
        else if (realName == "Copper#General") type=COPPER;
        else if (realName == "Silver#General") type=SILVER;
        else if (realName == "Gold#General") type=GOLD;
        else if (realName == "Drunk#Elephant") type=DRUNKELEPHANT;
        else if (realName == "Pawn") type=PAWN;
        else if (realName == "King") type=KING;
        else if (realName == "Reverse#Chariot") type=REVERSECHARIOT;
        else if (realName == "Bishop") type=BISHOP;
        else if (realName == "Blind#Tiger") type=BLINDTIGER;
        else if (realName == "Phoenix") type=PHOENIX;
        else if (realName == "Kylin") type=KYLIN;
        else if (realName == "Side#Mover") type=SIDEMOVER;
        else if (realName == "Vertical#Mover") type=VERTICALMOVER;
        else if (realName == "Rook") type=ROOK;
        else if (realName == "Dragon#Horse") type=HORSE;
        else if (realName == "Dragon#King") type=DRAGON;
        else if (realName == "Free#King") type=FREEKING;
        else if (realName == "Lion") type=LION;
        else if (realName == "Go-Between") type=GOBETWEEN;
        else cout << "Piece name " << realName << " not known to chuprof" << endl;

	// create the piece and place it on the board

	PieceCharacteristics *character=homeBoard.getPieces()[type];
	Piece *piece=new Piece(character,colour,false,false,false);
        Cell &thisCell=homeBoard.getCell(file,rank);
        thisCell.set(piece);
        if (piece->isCrownPrince() & colour) blackCrownPrinces++;
        else if (piece->isCrownPrince()) whiteCrownPrinces++;
      }
    }  

  data.close();


  homeBoard.setPiecesOnBoard(blackPieces,true);  
  homeBoard.setPiecesOnBoard(whitePieces,false);  
  homeBoard.setCrownPrinces(blackCrownPrinces,true);  
  homeBoard.setCrownPrinces(whiteCrownPrinces,false);  

  const Move humanMove(0,PAWN,Coordinates(0,3),Coordinates(0,4),Coordinates(),1,
		       false,false,false,false,false,false,false,false,
		       false,false,false,false);

  // now to create a GenerateMove

  GeneratedMove firstMove(humanMove);

  // finally we can set up the search

  Search theSearch(&firstMove, &homeBoard, colour, ply, extraMove, alwaysPromote,
		   false, NULL);

  jint value=theSearch.search(0, ply, false, false,Search::MINUSINFINITY,
			      Search::INFINITY,firstMove,NULL);

  jint count=theSearch.getNodesSearched();
  const Move bestMove=theSearch.getBestMove();

  char buffer[30];
  bestMove.notate(buffer);

  cout << "Searched " << count << " nodes, finding the move: " << buffer << 
    ", scoring " << value << endl;

  return 0;
}

