/** -*- mode: C++ -*-
 * cell.h defines a square of the board (as used by the computer player)
 *
 * Copyright 1999 Colin P. Adams
 *
 * Email: colin@colina.demon.co.uk
 *  
 *   This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef CELL_H 
#define CELL_H
#include <jni.h>
#include "piece.h"

enum Lighting {CLEAR, STEP, JUMP, LION_A, LION_B, STEP_CAPTURE, JUMP_CAPTURE,
	       LION_A_CAPTURE, LION_B_CAPTURE};

class Cell {
  Piece    *piece;
  Lighting  light;
 public:
  Cell() { piece = 0; light = CLEAR; }
  void reset() { piece = 0; }
  void set(Piece *p) { piece = p; }
  ~Cell() { if (piece) delete piece; }
  void clearLighting() { light = CLEAR; }
  Lighting getLighting() const { return light; }
  void setLighting(Lighting l) { light = l; }
  Piece *getPiece() const { return piece; }
  bool isBlack() { if (piece) return piece->isBlack(); else return true; }
  PieceType getAbbrev() { if (piece == 0) return NONE; else return piece->getAbbrev(); }
  jint getValue() { if (piece) return piece->getValue(); else return 0; }
  bool getColour() { if (piece) return piece->getColour(); else return true;  }
};
#endif
