/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HtmlPanel
extends JPanel
implements HyperlinkListener {
    private static final String $0 = "HtmlPanel.nrx";
    private static final boolean False = false;
    private JEditorPane html;
    private URL url = null;
    private String prefix;
    private JScrollPane scroller;
    private JViewport vp;
    private Cursor c;
    private Cursor waitCursor;

    public HtmlPanel(String string) {
        MalformedURLException malformedURLException = null;
        IOException iOException = null;
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        try {
            this.prefix = "file:" + System.getProperty("user.dir") + System.getProperty("file.separator");
            try {
                this.url = new URL(this.prefix + string);
            }
            catch (MalformedURLException malformedURLException2) {
                malformedURLException = malformedURLException2;
                JOptionPane.showMessageDialog(null, "Malformed URL: " + malformedURLException.toString() + "\nReport this to colin@colina.demon.co.uk", "URL error", 0);
                this.url = null;
            }
            if (this.url != null) {
                this.html = new JEditorPane(this.url);
                this.html.setEditable(false);
                this.html.addHyperlinkListener(this);
                this.scroller = new JScrollPane();
                this.scroller.setBorder(new SoftBevelBorder(1));
                this.vp = this.scroller.getViewport();
                this.vp.add(this.html);
                this.vp.setScrollMode(2);
                this.add((Component)this.scroller, "Center");
            }
        }
        catch (MalformedURLException malformedURLException3) {
            malformedURLException = malformedURLException3;
            JOptionPane.showMessageDialog(null, "Malformed URL: " + malformedURLException.toString() + "\nReport this to colin@colina.demon.co.uk", "URL error", 0);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            JOptionPane.showMessageDialog(null, "I/O Exception: " + iOException.toString() + "\nReport this to colin@colina.demon.co.uk", "URL error", 0);
        }
        this.setPreferredSize(new Dimension(800, 600));
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(hyperlinkEvent.getURL());
        }
    }

    protected void linkActivated(URL uRL) {
        this.c = this.html.getCursor();
        this.waitCursor = Cursor.getPredefinedCursor(3);
        this.html.setCursor(this.waitCursor);
        SwingUtilities.invokeLater(new PageLoader(uRL, this.c, this.html));
    }
}

