/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedList;
import java.util.ListIterator;

public class Evaluator
extends Thread {
    private static final String $0 = "Evaluator.nrx";
    private static final boolean False = false;
    private static final boolean True = true;
    private static final int[][] lionWeights = new int[][]{{70, 80, 135, 180, 215, 300, 300, 250, 240, 230, 175, 160}, {87, 90, 145, 190, 250, 350, 350, 345, 330, 235, 200, 170}, {88, 135, 185, 220, 350, 390, 380, 365, 340, 240, 230, 175}, {85, 90, 150, 200, 210, 230, 240, 245, 235, 230, 180, 88}, {70, 86, 100, 110, 120, 152, 160, 155, 152, 151, 90, 75}, {50, 60, 70, 76, 80, 90, 100, 95, 86, 80, 70, 55}, {35, 45, 55, 70, 75, 150, 151, 85, 75, 65, 55, 40}, {20, 35, 45, 55, 65, 70, 75, 70, 60, 50, 40, 25}, {-100, -80, -50, 12, 5, 10, 20, 12, 5, -40, -65, -85}, {-300, -250, -150, -100, -10, 0, 0, -5, -95, -145, -235, -275}, {-400, -350, -300, -250, -200, -150, -155, -205, -255, -305, -355, -405}, {-500, -450, -400, -350, -300, -300, -300, -305, -355, -405, -455, -505}};
    private static final int[][] pawnWeights = new int[][]{{141, 141, 141, 141, 141, 141, 141, 141, 141, 141, 141, 141}, {121, 121, 121, 121, 121, 121, 121, 121, 121, 121, 121, 121}, {101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101}, {100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100}, {90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90}, {10, 12, 12, 12, 13, 13, 13, 13, 12, 12, 12, 10}, {9, 11, 11, 11, 12, 12, 12, 12, 11, 11, 11, 9}, {10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10}, {-9, -8, -50, -50, -55, -35, -30, -54, -50, -50, -8, -9}};
    private static final int[][] phoenixWeights = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220}, {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, {0, 0, 86, 87, 0, 0, 88, 92, 0, 0, 0, 0}, {0, 0, 74, 73, 0, 0, 74, 73, 0, 0, 0, 0}, {0, 0, 0, 0, 73, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 74, 70, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    private static final int[][] copperWeights = new int[][]{{200, 204, 205, 210, 220, 225, 225, 220, 210, 205, 204, 200}, {206, 208, 215, 225, 230, 235, 235, 230, 225, 215, 208, 206}, {203, 205, 210, 220, 225, 230, 230, 225, 220, 210, 205, 203}, {201, 203, 205, 208, 210, 220, 220, 210, 209, 207, 204, 201}, {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, {160, 165, 170, 175, 180, 181, 181, 180, 176, 171, 166, 160}, {40, 60, 60, 80, 90, 95, 95, 91, 80, 62, 62, 40}, {34, 58, 56, 70, 81, 85, 85, 81, 72, 58, 60, 34}, {25, 35, 35, 60, 75, 80, 80, 75, 60, 35, 35, 25}, {10, 20, 30, 50, 50, 60, 60, 50, 50, 30, 30, 10}, {0, 20, 20, 29, 20, 40, 40, 20, 29, 20, 20, 0}, {-20, -10, 0, 0, 0, 0, 0, 0, 0, 0, -10, -20}};
    private static final int[][] silverWeights = new int[][]{{200, 204, 205, 210, 220, 225, 225, 220, 210, 205, 204, 200}, {206, 208, 215, 225, 230, 235, 235, 230, 225, 215, 208, 206}, {203, 205, 210, 220, 225, 230, 230, 225, 220, 210, 205, 203}, {201, 203, 205, 208, 210, 220, 220, 210, 209, 207, 204, 201}, {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, {160, 165, 170, 175, 180, 181, 181, 180, 176, 171, 166, 160}, {40, 60, 60, 80, 95, 90, 90, 96, 80, 62, 62, 40}, {34, 58, 56, 70, 85, 81, 81, 85, 72, 58, 60, 34}, {25, 35, 35, 60, 75, 80, 80, 75, 60, 35, 35, 25}, {10, 20, 30, 50, 50, 60, 60, 50, 50, 30, 30, 10}, {0, 20, 20, 28, 20, 40, 40, 20, 28, 20, 20, 0}, {-20, -10, 0, 0, 0, 0, 0, 0, 0, 0, -10, -20}};
    private static final int[][] leopardWeights = new int[][]{{200, 204, 205, 210, 220, 225, 225, 220, 210, 205, 204, 200}, {206, 208, 215, 225, 230, 235, 235, 230, 225, 215, 208, 206}, {203, 205, 210, 220, 225, 230, 230, 225, 220, 210, 205, 203}, {201, 203, 205, 208, 210, 220, 220, 210, 209, 207, 204, 201}, {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, {160, 165, 170, 175, 180, 181, 181, 180, 176, 171, 166, 160}, {40, 60, 60, 80, 95, 90, 90, 96, 80, 62, 62, 40}, {34, 58, 56, 70, 85, 81, 81, 85, 72, 58, 60, 34}, {25, 35, 35, 60, 75, 80, 80, 75, 60, 35, 35, 25}, {10, 20, 30, 31, 50, 60, 60, 50, 31, 30, 30, 10}, {0, 8, 8, 28, 20, 40, 40, 20, 28, 8, 8, 0}, {-20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -20}};
    private static final int[][] horseWeights = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58}, {58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58}, {57, 58, 58, 58, 57, 57, 57, 57, 58, 58, 58, 57}, {57, 59, 58, 58, 57, 57, 57, 57, 58, 58, 59, 57}, {56, 58, 57, 58, 49, 49, 49, 49, 58, 57, 58, 56}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    private static final int[][] dragonWeights = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 15, 0, 15, 15, 0, 15, 0, 0, 0}, {30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 50}};
    private static final int[][] kylinWeights = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 800, 0, 800, 0, 800, 0, 800, 0, 800, 0, 800}, {350, 0, 350, 0, 350, 0, 350, 0, 350, 0, 350, 0}, {0, 23, 0, 22, 0, 22, 0, 22, 0, 23, 0, 22}, {21, 0, 21, 0, 21, 0, 21, 0, 21, 0, 21, 0}, {0, 19, 0, 0, 0, 20, 0, 19, 0, 19, 0, 19}, {0, 0, 2, 0, 0, 0, 0, 0, 4, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 10, 0, 2, 0, 0}, {0, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0}};
    private static final int[][] sideWeights = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    private boolean colour;
    private int maximiumDepth;
    private Board thisBoard;
    private int count;
    private GeneratedMove gm3;
    private GeneratedMove firstMove;
    private boolean extraMove;
    private Move bestMove;
    private String finalResult;
    private TwoTargets targets;

    public Evaluator(GeneratedMove generatedMove, Board board, boolean bl, int n, boolean bl2) {
        this.colour = bl;
        this.maximiumDepth = n;
        this.thisBoard = board;
        this.firstMove = generatedMove;
        this.count = 0;
        this.extraMove = bl2;
    }

    public void run() {
        int n = 0;
        n = this.search(0, this.maximiumDepth, false, false, -1000000, 1000000, this.firstMove);
        this.finalResult = "Searched " + this.count + " " + "nodes, scoring" + " " + n;
    }

    public int search(int n, int n2, boolean bl, boolean bl2, int n3, int n4, GeneratedMove generatedMove) {
        boolean bl3 = false;
        LinkedList linkedList = null;
        ListIterator listIterator = null;
        int n5 = 0;
        GeneratedMove generatedMove2 = null;
        int n6 = 0;
        int n7 = 0;
        Move move = null;
        boolean bl4 = false;
        Generator generator = null;
        byte by = 0;
        boolean bl5 = false;
        bl3 = n % 2 == 0;
        move = generatedMove.getMove();
        bl4 = move.wasFirstCaptured();
        by = move.squares();
        bl5 = move.wasSecondCaptured();
        n5 = n2;
        if (n == n2 & bl4 & this.extraMove && !(by == 2 & !bl5 & bl)) {
            ++n5;
            bl2 = true;
        }
        if (n != 0 & !generatedMove.evaluateNow()) {
            generatedMove.updatePosition(this.thisBoard);
        }
        if (n != 0 && !generatedMove.isLegal()) {
            return -2000000;
        }
        if (n == n5 | generatedMove.evaluateNow()) {
            n7 = this.evaluate();
            if (!generatedMove.evaluateNow()) {
                generatedMove.restorePosition(this.thisBoard);
            }
            return n7;
        }
        Thread.yield();
        generator = new Generator(this.thisBoard, move, bl);
        generator.generate();
        Thread.yield();
        linkedList = generator.getMoves();
        if (bl) {
            generatedMove2 = new GeneratedMove(generatedMove);
            generatedMove2.setEvaluateNow();
            linkedList.add(0, generatedMove2);
        }
        listIterator = linkedList.listIterator();
        if (bl2) {
            bl = true;
        }
        if (!bl3) {
            while (listIterator.hasNext()) {
                generatedMove2 = (GeneratedMove)listIterator.next();
                n6 = this.search(n + 1, n5, bl, bl2, n3, n4, generatedMove2);
                if (n6 == -2000000) {
                    listIterator.remove();
                    continue;
                }
                n4 = Math.min(n4, n6);
                Thread.yield();
                ++this.count;
                if (n3 < n4) continue;
                generatedMove.restorePosition(this.thisBoard);
                return n3;
            }
            generatedMove.restorePosition(this.thisBoard);
            return n4;
        }
        while (listIterator.hasNext()) {
            generatedMove2 = (GeneratedMove)listIterator.next();
            n6 = this.search(n + 1, n5, bl, bl2, n3, n4, generatedMove2);
            if (n6 == -2000000) {
                listIterator.remove();
                continue;
            }
            if (n == 0 & n6 > n3) {
                this.bestMove = generatedMove2.getMove().replicate();
            }
            n3 = Math.max(n3, n6);
            Thread.yield();
            ++this.count;
            if (n3 < n4) continue;
            if (n != 0) {
                generatedMove.restorePosition(this.thisBoard);
            }
            return n4;
        }
        if (n != 0) {
            generatedMove.restorePosition(this.thisBoard);
        }
        return n3;
    }

    public int evaluate() {
        PieceRepresentation pieceRepresentation = null;
        int n = 0;
        Cell cell = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        n6 = 0;
        if (this.thisBoard.getCrownPrinces(this.colour) > 0) {
            n6 += 500000;
        }
        if (this.thisBoard.getCrownPrinces(this.colour) == 2) {
            n6 += 900;
        }
        if (this.thisBoard.getCrownPrinces(!this.colour) > 0) {
            n6 -= 500000;
        }
        if (this.thisBoard.getCrownPrinces(!this.colour) == 2) {
            n6 -= 900;
        }
        n2 = 0;
        while (n2 <= 11) {
            n3 = 11;
            while (n3 >= 0) {
                cell = this.thisBoard.getCell(n3, n2);
                pieceRepresentation = cell.piece();
                if (pieceRepresentation != null) {
                    n = pieceRepresentation.value();
                    if (pieceRepresentation.isBlack()) {
                        n5 = 11 - n3;
                        n4 = n2;
                    } else {
                        n5 = n3;
                        n4 = 11 - n2;
                    }
                    String string = pieceRepresentation.getAbbrev();
                    if (string.equals("Ph")) {
                        n += phoenixWeights[n4][n5];
                    } else if (string.equals("Ln")) {
                        n += lionWeights[n4][n5];
                    } else if (string.equals("+Ky")) {
                        n += lionWeights[n4][n5];
                    } else if (string.equals("Ky")) {
                        n += kylinWeights[n4][n5];
                    } else if (string.equals("P")) {
                        n += pawnWeights[n4][n5];
                    } else if (string.equals("C")) {
                        n += copperWeights[n4][n5];
                    } else if (string.equals("S")) {
                        n += silverWeights[n4][n5];
                    } else if (string.equals("FL")) {
                        n += leopardWeights[n4][n5];
                    } else if (string.equals("DH")) {
                        n += horseWeights[n4][n5];
                    } else if (string.equals("DK")) {
                        n += dragonWeights[n4][n5];
                    } else if (string.equals("SM")) {
                        n += sideWeights[n4][n5];
                    }
                    n6 = pieceRepresentation.isBlack() == this.colour ? (n6 += n) : (n6 -= n);
                }
                --n3;
            }
            ++n2;
        }
        return n6;
    }

    public NewPosition getFinalPosition() {
        this.gm3 = new GeneratedMove(this.bestMove, 0);
        this.gm3.updatePosition(this.thisBoard);
        this.targets = this.gm3.getTargets();
        return new NewPosition(this.thisBoard, this.bestMove);
    }

    public String getFinalResult() {
        return this.finalResult;
    }

    public TwoTargets getTargets() {
        return this.targets;
    }
}

