/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class EditDialog
extends JDialog
implements ActionListener {
    private static final String $0 = "EditDialog.nrx";
    private static final boolean False = false;
    private static final boolean True = true;
    private static final int originalSquare = 35;
    private Cell cell;
    private PieceRepresentation pieceRep;
    private Piece piece;
    private int graphic;
    private JButton iconLabel;
    private JComboBox nameLabel;
    private String[] names;
    private int nameIndex;
    private JButton delayedLabel;
    private String delayed;
    private JButton OKLabel;
    private String OK;
    private Board homeBoard;
    private Image piecesImage;
    private Graphics2D g;
    private BufferedImage image;
    private int X;
    private int Y;
    private MediaTracker tracker;
    private String pieceName;
    private boolean colour;
    private Color fg;

    public EditDialog(Board board, Coordinates coordinates, Image image, JFrame jFrame) {
        super(jFrame, "Edit Square " + coordinates.describe(), true);
        this.homeBoard = board;
        this.piecesImage = image;
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.names = new String[]{"<empty>", "King", "Rook", "Gold General", "Bishop", "Pawn", "Dragon King", "Lance", "Dragon Horse", "Silver General", "Blind Tiger", "Copper General", "Go-Between", "Drunk Elephant", "Ferocious Leopard", "Free King", "Kylin", "Lion", "Phoenix", "Reverse Chariot", "Side Mover", "Vertical Mover", "Horned Falcon", "Soaring#Eagle", "White Horse", "Whale", "Flying Stag", "Free Boar", "(Side Mover)", "(Vertical Mover)", "Flying Ox", "Crown Prince", "(Lion)", "(Free King)", "(Drunk#Elephant)", "(Dragon King)", "(Bishop)", "(Rook)", "(Dragon Horse)", "Tokin"};
        this.nameLabel = new JComboBox<Object>((Object[])this.names);
        this.cell = this.homeBoard.getCell(coordinates.x(), coordinates.y());
        this.pieceRep = this.cell.piece();
        if (this.pieceRep == null) {
            this.graphic = 78;
            this.nameIndex = 0;
            this.delayed = "";
            this.OK = "";
            this.fg = Color.red;
        } else {
            this.graphic = this.pieceRep.getPiece().getGraphic() - 1;
            this.nameIndex = this.graphic + 1;
            this.colour = this.pieceRep.isBlack();
            this.fg = this.colour ? Color.black : Color.white;
            if (this.pieceRep.isPromoted()) {
                this.delayed = "";
                this.OK = "Already promoted";
            } else if (this.pieceRep.wasDelayed()) {
                this.delayed = "Did not promote";
                this.OK = this.pieceRep.isOK() ? "OK to promote" : "May not promote yet";
            } else {
                this.delayed = "Has not yet promoted";
                this.OK = "OK to promote";
            }
        }
        this.nameLabel.setSelectedIndex(this.nameIndex);
        this.nameLabel.setActionCommand("NAME");
        this.nameLabel.addActionListener(this);
        this.nameLabel.setForeground(this.fg);
        this.getContentPane().add(this.nameLabel);
        this.X = this.graphic % 10 * 35;
        this.Y = this.graphic / 10 * 35;
        this.image = new BufferedImage(68, 68, 1);
        this.g = this.image.createGraphics();
        this.tracker = new MediaTracker(this);
        this.tracker.addImage(this.piecesImage, 0);
        this.g.drawImage(this.piecesImage, 0, 0, 68, 68, this.X + 1, this.Y + 1, this.X + 35 - 1, this.Y + 35 - 1, this);
        this.iconLabel = new JButton(new ImageIcon(this.image));
        this.iconLabel.setActionCommand("COLOUR");
        this.iconLabel.addActionListener(this);
        this.getContentPane().add(this.iconLabel);
        this.delayedLabel = new JButton(this.delayed);
        this.delayedLabel.setActionCommand("DELAYED");
        this.delayedLabel.addActionListener(this);
        this.getContentPane().add(this.delayedLabel);
        this.OKLabel = new JButton(this.OK);
        this.OKLabel.setActionCommand("OK");
        this.OKLabel.addActionListener(this);
        this.getContentPane().add(this.OKLabel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = null;
        string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            if (this.OK.equals("May not promote yet")) {
                this.OK = "OK to promote";
                this.OKLabel.setText(this.OK);
                this.pieceRep.setOK(true);
            } else if (this.OK.equals("OK to promote") && this.delayed.equals("Did not promote")) {
                this.OK = "May not promote yet";
                this.OKLabel.setText(this.OK);
                this.pieceRep.setOK(false);
            }
        } else if (string.equals("DELAYED")) {
            if (this.delayed.equals("Did not promote")) {
                this.pieceRep.setDelayed(false);
                this.delayed = "Has not yet promoted";
                this.delayedLabel.setText(this.delayed);
                this.OK = "OK to promote";
                this.OKLabel.setText(this.OK);
                this.pieceRep.setOK(false);
            } else if (this.delayed.equals("Has not yet promoted")) {
                this.pieceRep.setDelayed(true);
                this.delayed = "Did not promote";
                this.delayedLabel.setText(this.delayed);
                this.OK = "OK to promote";
                this.OKLabel.setText(this.OK);
                this.pieceRep.setOK(false);
            }
        } else if (string.equals("COLOUR")) {
            if (this.nameIndex != 0) {
                if (this.pieceRep.getPiece().isCrownPrince()) {
                    this.homeBoard.decrementCrownPrinces(this.colour);
                    this.homeBoard.incrementCrownPrinces(!this.colour);
                }
                this.homeBoard.decrementPiecesOnBoard(this.colour);
                this.homeBoard.incrementPiecesOnBoard(!this.colour);
                if (this.colour) {
                    this.colour = false;
                    this.fg = Color.white;
                } else {
                    this.colour = true;
                    this.fg = Color.black;
                }
            }
            this.pieceRep.setColour(this.colour);
            this.nameLabel.setForeground(this.fg);
        } else if (string.equals("NAME")) {
            if (this.pieceRep != null) {
                if (this.pieceRep.getPiece().isCrownPrince()) {
                    this.homeBoard.decrementCrownPrinces(this.colour);
                }
                this.homeBoard.decrementPiecesOnBoard(this.colour);
            }
            this.nameIndex = this.nameLabel.getSelectedIndex();
            this.pieceName = (String)this.nameLabel.getSelectedItem();
            if (this.nameIndex != 0) {
                this.fg = this.colour ? Color.black : Color.white;
                if (this.pieceName.charAt(0) == '(') {
                    this.pieceName = "*P*" + this.pieceName.substring(1, this.pieceName.length() - 1);
                }
                this.pieceName = this.pieceName.replace('#', ' ');
                this.piece = (Piece)this.homeBoard.getPieces().accessPieces().get(this.pieceName);
                this.pieceRep = new PieceRepresentation(this.piece, this.colour);
                this.cell.set(this.pieceRep);
                if (this.pieceRep.isPromoted()) {
                    this.delayed = "";
                    this.OK = "Already promoted";
                } else {
                    this.OK = "OK to promote";
                    this.delayed = "Has not yet promoted";
                }
                this.graphic = this.piece.getGraphic() - 1;
            } else {
                this.graphic = 78;
                this.fg = Color.red;
                this.delayed = "";
                this.OK = "";
                this.cell.reset();
            }
            this.nameLabel.setForeground(this.fg);
            this.OKLabel.setText(this.OK);
            this.delayedLabel.setText(this.delayed);
            if (this.pieceRep.getPiece().isCrownPrince()) {
                this.homeBoard.incrementCrownPrinces(this.colour);
            }
            this.homeBoard.incrementPiecesOnBoard(this.colour);
            this.X = this.graphic % 10 * 35;
            this.Y = this.graphic / 10 * 35;
            this.tracker = new MediaTracker(this);
            this.tracker.addImage(this.piecesImage, 0);
            this.g.drawImage(this.piecesImage, 0, 0, 68, 68, this.X + 1, this.Y + 1, this.X + 35 - 1, this.Y + 35 - 1, this);
            this.pack();
        }
    }
}

