/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.JOptionPane;

public class Computer
extends Thread {
    private static final String $0 = "Computer.nrx";
    private static final boolean False = false;
    private static final boolean True = true;
    protected static int retries;
    private boolean colour;
    private Board homeBoard = null;
    private Move previousMove;
    private NewPosition position = null;
    private boolean statistics;
    private String finalResult;
    private long seconds;
    private long milliSeconds;
    private int lions;
    private int mb;
    private int mr;
    private boolean alwaysPromote;
    private boolean matingMode;
    private int count;
    private int exactScores;
    private int lowerCutoffs;
    private int upperCutoffs;
    private int nearMisses;
    private int hashingCollisions;
    private int hashingErrors;
    private int replacements;
    private int repetitionCount;
    private int transpositionEntries;
    private int entries;
    private boolean suppressRepetitionChecking;
    private TwoTargets targets;
    private long timeRemaining;
    private int maxDepth;
    private boolean log;
    private int detailed;
    private String logFileName;
    private boolean showpc;
    private boolean logStats;
    private String[] principalContinuation;
    private SearchParameters searchParms;

    public Computer(int n, Board board, Move move, boolean bl, boolean bl2, boolean bl3, int n2, int n3, boolean bl4, boolean bl5, long l, boolean bl6, int n4, String string, SearchParameters searchParameters, boolean bl7, boolean bl8) {
        this.homeBoard = board;
        this.previousMove = move;
        this.position = null;
        this.colour = bl;
        this.alwaysPromote = bl2;
        this.matingMode = bl3;
        this.lions = n;
        this.mb = n2;
        this.mr = n3;
        this.statistics = bl4;
        this.suppressRepetitionChecking = bl5;
        this.timeRemaining = l;
        this.log = bl6;
        this.detailed = n4;
        this.logFileName = string;
        this.showpc = bl7;
        this.logStats = bl8;
        this.searchParms = searchParameters;
    }

    public NewPosition get() {
        return this.position;
    }

    public void run() {
        long l = 0L;
        long l2 = 0L;
        Player player = null;
        Move move = null;
        Board board = null;
        ComputerResult computerResult = null;
        int n = 0;
        boolean bl = false;
        if (this.statistics) {
            l = System.currentTimeMillis();
        }
        board = new Board(this.homeBoard);
        if (this.suppressRepetitionChecking) {
            bl = false;
            n = 2;
        } else {
            bl = true;
            n = 1;
        }
        boolean bl2 = true;
        while (true) {
            if (bl2) {
                bl2 = false;
            } else if (n == 0) break;
            player = new Player(this.previousMove, board, this.colour, this.lions, this.alwaysPromote, this.matingMode, this.mb, this.mr, bl, this.timeRemaining, this.log, this.detailed, this.logFileName, this.searchParms, this.showpc, this.logStats);
            player.start();
            try {
                player.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --n;
            move = player.getBestMove();
            this.targets = new TwoTargets();
            if (!board.performMove(move, this.targets)) {
                if (bl & !this.matingMode) {
                    JOptionPane.showMessageDialog(null, "The computer has violated the repetition rule!", "Repetition rule", 0);
                    continue;
                }
                if (this.matingMode) {
                    n = 0;
                    continue;
                }
                ++retries;
                bl = true;
                board = new Board(this.homeBoard);
                continue;
            }
            n = 0;
        }
        if (this.showpc) {
            this.principalContinuation = player.getPrinicpalContinuation();
        }
        this.position = new NewPosition(board, move);
        if (this.statistics) {
            l2 = System.currentTimeMillis();
            this.seconds = (l2 - l) / 1000L;
            this.milliSeconds = (l2 - l) % 1000L;
            this.finalResult = player.getFinalResult();
        }
        if (this.statistics) {
            computerResult = player.getResult();
            this.count = computerResult.getCount();
            this.exactScores = computerResult.getExactScores();
            this.lowerCutoffs = computerResult.getLowerCutoffs();
            this.upperCutoffs = computerResult.getUpperCutoffs();
            this.nearMisses = computerResult.getNearMisses();
            this.hashingCollisions = computerResult.getHashingCollisions();
            this.hashingErrors = computerResult.getHashingErrors();
            this.replacements = computerResult.getReplacements();
            this.repetitionCount = computerResult.getRepetitionCount();
            this.transpositionEntries = computerResult.getTranspositionEntries();
            this.entries = computerResult.getTotalEntries();
            this.maxDepth = computerResult.getMaximumDepth();
        }
        player = null;
    }

    public String getFinalResult() {
        return this.finalResult;
    }

    public int getCount() {
        return this.count;
    }

    public int getExactScores() {
        return this.exactScores;
    }

    public int getLowerCutoffs() {
        return this.lowerCutoffs;
    }

    public int getUpperCutoffs() {
        return this.upperCutoffs;
    }

    public int getNearMisses() {
        return this.nearMisses;
    }

    public int getHashingCollisions() {
        return this.hashingCollisions;
    }

    public int getHashingErrors() {
        return this.hashingErrors;
    }

    public int getReplacements() {
        return this.replacements;
    }

    public int getRepetitionCount() {
        return this.repetitionCount;
    }

    public int getTranspositionEntries() {
        return this.transpositionEntries;
    }

    public int getTotalEntries() {
        return this.entries;
    }

    public int getRetries() {
        return retries;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public long getMilliSeconds() {
        return this.milliSeconds;
    }

    public TwoTargets getTargets() {
        return this.targets;
    }

    public int getMaximumDepth() {
        return this.maxDepth;
    }

    public String[] getPrinicpalContinuation() {
        return this.principalContinuation;
    }
}

