/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.zip.DataFormatException;
import javax.swing.JOptionPane;

public class Board
implements Lighting,
Directions,
MoveStatus {
    private static final String $0 = "Board.nrx";
    private static final boolean False = false;
    private static final boolean True = true;
    private ArrayIndexOutOfBoundsException exc;
    private Cell tempCell;
    private PiecesData piecesData = null;
    private Cell[][] cells = new Cell[12][12];
    private boolean interactive;
    private byte[] piecesOnBoard = new byte[2];
    private byte[] crownPrinces = new byte[2];
    private HashSet[] positions = new HashSet[2];

    public void setInteractive(boolean bl) {
        this.interactive = bl;
    }

    public Board(Board board) {
        int n = 0;
        int n2 = 0;
        this.piecesData = board.piecesData;
        this.interactive = false;
        this.positions[0] = (HashSet)board.positions[0].clone();
        this.positions[1] = (HashSet)board.positions[1].clone();
        this.piecesOnBoard[0] = board.piecesOnBoard[0];
        this.piecesOnBoard[1] = board.piecesOnBoard[1];
        this.crownPrinces[0] = board.crownPrinces[0];
        this.crownPrinces[1] = board.crownPrinces[1];
        n = 0;
        while (n <= 11) {
            n2 = 11;
            while (n2 >= 0) {
                this.cells[n2][n] = board.cells[n2][n].replicate();
                --n2;
            }
            ++n;
        }
    }

    public Board(boolean bl, String string) throws FileNotFoundException, IOException, DataFormatException {
        File file = null;
        BufferedReader bufferedReader = null;
        int n = 0;
        int n2 = 0;
        String string2 = null;
        StringTokenizer stringTokenizer = null;
        boolean bl2 = false;
        String string3 = null;
        Piece piece = null;
        this.interactive = true;
        this.positions[bl ? 1 : 0] = new HashSet(17);
        this.positions[!bl ? 1 : 0] = new HashSet(17);
        this.piecesData = new PiecesData();
        this.piecesOnBoard[0] = 0;
        this.piecesOnBoard[1] = 0;
        this.crownPrinces[0] = 0;
        this.crownPrinces[1] = 0;
        file = new File(string);
        if (!file.canRead()) {
            JOptionPane.showMessageDialog(null, "Unable to read file " + file.getAbsolutePath(), "Unable to read file", 0);
        } else {
            bufferedReader = new BufferedReader(new FileReader(file));
            n = 0;
            while (n <= 11) {
                string2 = bufferedReader.readLine();
                stringTokenizer = new StringTokenizer(string2);
                n2 = 11;
                while (n2 >= 0) {
                    bl2 = false;
                    this.cells[n2][n] = new Cell();
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new DataFormatException("Not enough pieces specified in board.data");
                    }
                    string3 = stringTokenizer.nextToken();
                    if (!(string3 = string3.replace('#', ' ')).equals(" ")) {
                        bl2 = string3.startsWith("B");
                        string3 = string3.substring(1);
                        piece = (Piece)this.piecesData.accessPieces().get(string3);
                        this.cells[n2][n].set(new PieceRepresentation(piece, bl2));
                        this.incrementPiecesOnBoard(bl2);
                        if (piece.isCrownPrince()) {
                            this.incrementCrownPrinces(bl2);
                        }
                    }
                    --n2;
                }
                ++n;
            }
        }
    }

    public Board(String string, boolean bl) throws FileNotFoundException, IOException {
        int n = 0;
        int n2 = 0;
        this.interactive = true;
        this.positions[0] = new HashSet(17);
        this.positions[1] = new HashSet(17);
        this.piecesData = new PiecesData();
        this.piecesOnBoard[0] = 0;
        this.piecesOnBoard[1] = 0;
        this.crownPrinces[0] = 0;
        this.crownPrinces[1] = 0;
        n = 0;
        while (n <= 11) {
            n2 = 0;
            while (n2 <= 11) {
                this.cells[n2][n] = new Cell();
                ++n2;
            }
            ++n;
        }
        this.parseForsyth(string, bl);
    }

    public Board replicate() {
        return new Board(this);
    }

    public PieceRepresentation getPiece(int n, int n2) {
        return this.cells[n][n2].piece();
    }

    public Cell getCell(Coordinates coordinates) {
        return this.getCell(coordinates.x(), coordinates.y());
    }

    public Cell getCell(int n, int n2) {
        return this.cells[n][n2];
    }

    public boolean onBoard(Coordinates coordinates) {
        int n = 0;
        int n2 = 0;
        try {
            n = coordinates.x();
            n2 = coordinates.y();
            this.tempCell = this.cells[n][n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.exc = arrayIndexOutOfBoundsException;
            return false;
        }
        return true;
    }

    public boolean selectPiece(Coordinates coordinates, Move move) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        Cell cell = null;
        PieceRepresentation pieceRepresentation = null;
        Piece piece = null;
        String string = null;
        try {
            bl = move.isBlack();
            n = coordinates.x();
            n2 = coordinates.y();
            cell = this.cells[n][n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.exc = arrayIndexOutOfBoundsException;
            return false;
        }
        pieceRepresentation = cell.piece();
        if (pieceRepresentation == null) {
            return false;
        }
        piece = pieceRepresentation.getPiece();
        if (piece == null) {
            return false;
        }
        if (cell.isBlack() == bl) {
            string = piece.getAbbrev();
            move.setAbbrev(string);
            if (string.equals("Ln") | string.equals("+Ky")) {
                move.setLionSource(true);
            }
            move.setSource(coordinates);
            return true;
        }
        return false;
    }

    public int movePiece(Coordinates coordinates, Move move, Move move2, int n) {
        Coordinates coordinates2 = null;
        Coordinates coordinates3 = null;
        Cell cell = null;
        PieceRepresentation pieceRepresentation = null;
        Piece piece = null;
        String string = null;
        Cell cell2 = null;
        PieceRepresentation pieceRepresentation2 = null;
        Piece piece2 = null;
        String string2 = null;
        boolean bl = false;
        bl = false;
        if (move.isPending()) {
            if (n != 6) {
                return 5;
            }
            move.nextStage();
        }
        move.setDestination(coordinates);
        switch (move.squares()) {
            case 1: {
                coordinates3 = move.getSource();
                break;
            }
            case 2: {
                coordinates3 = move.getStage1();
                break;
            }
        }
        if (coordinates == coordinates3) {
            JOptionPane.showMessageDialog(null, "Board.movePiece on a de-select\nReport this to colin@colina.demon.co.uk", "Invariant Violated", 0);
            return 5;
        }
        coordinates2 = move.getSource();
        cell = this.cells[coordinates2.x()][coordinates2.y()];
        pieceRepresentation = cell.piece();
        piece = pieceRepresentation.getPiece();
        string = piece.getAbbrev();
        if (move.squares() == 1) {
            move.setAbbrev(string);
        }
        piece2 = (pieceRepresentation2 = (cell2 = this.cells[coordinates.x()][coordinates.y()]).piece()) != null ? pieceRepresentation2.getPiece() : (Piece)null;
        if (move.squares() == 2 & coordinates2.equals(coordinates)) {
            bl = true;
        }
        if (piece2 != null & !bl) {
            if (move.isPending()) {
                move.setSecondCapture(true);
            } else {
                move.setFirstCapture(true);
            }
            string2 = piece2.getAbbrev();
            if (string2.equals("Ln") | string2.equals("+Ky")) {
                move.setLionTarget();
            }
            if (pieceRepresentation2.isBlack() == pieceRepresentation.isBlack()) {
                return 5;
            }
        }
        if (this.isLegal(move, move2)) {
            if (move.isLionTarget() & !move.isLionSource()) {
                move.setLionCaptured(true);
            }
            this.clearLighting();
            if (move.squares() == 1 & move.isAnotherMovePossible()) {
                move.setDoubleCapture(false);
                if (move.isLionSource() && move.wasFirstCaptured() && !(string2.equals("P") | string2.equals("GB"))) {
                    move.setDoubleCapture(true);
                }
            }
            if (move.isAnotherMovePossible() & !move.isPending()) {
                return 3;
            }
            move.setPending(false);
            if (move.squares() == 1 & !move.isAnotherMovePossible() & !move.isPending()) {
                return 2;
            }
            return 4;
        }
        if (!move.isPending()) {
            move = null;
        } else {
            move.previousStage();
        }
        return 5;
    }

    public void clearLighting() {
        int n = 0;
        int n2 = 0;
        n = 0;
        while (n <= 11) {
            n2 = 11;
            while (n2 >= 0) {
                this.cells[n2][n].clearLighting();
                --n2;
            }
            ++n;
        }
    }

    public void setLighting(Coordinates coordinates) {
        Cell cell = null;
        PieceRepresentation pieceRepresentation = null;
        Piece piece = null;
        int n = 0;
        int n2 = 0;
        Coordinates coordinates2 = null;
        Cell cell2 = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        this.clearLighting();
        cell = this.cells[coordinates.x()][coordinates.y()];
        pieceRepresentation = cell.piece();
        if (pieceRepresentation == null) {
            throw new IllegalStateException("Board.setLighting(Coordinates) called without a piece");
        }
        piece = pieceRepresentation.getPiece();
        if (piece == null) {
            throw new IllegalStateException("Board.setLighting(Coordinates) called without a piece");
        }
        n = 0;
        while (n <= 7) {
            n2 = piece.getRange(n);
            coordinates2 = coordinates.replicate();
            try {
                int n7 = n2;
                while (n7 > 0) {
                    coordinates2.inc(n, 1, cell.isBlack());
                    cell2 = this.cells[coordinates2.x()][coordinates2.y()];
                    if (cell2.piece() != null & cell2.isBlack() == cell.isBlack()) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    if (cell2.piece() != null) {
                        cell2.setLighting(5);
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    cell2.setLighting(1);
                    --n7;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.exc = arrayIndexOutOfBoundsException;
            }
            int n8 = n3 = piece.getJump(n) ? 1 : 0;
            if (n3 > 0) {
                try {
                    coordinates2 = coordinates.replicate();
                    coordinates2.inc(n, 2, cell.isBlack());
                    cell2 = this.cells[coordinates2.x()][coordinates2.y()];
                    if (!(cell2.piece() != null & cell2.isBlack() == cell.isBlack())) {
                        if (cell2.piece() == null) {
                            cell2.setLighting(2);
                        } else {
                            cell2.setLighting(6);
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.exc = arrayIndexOutOfBoundsException;
                }
            }
            if (piece.getLion(n)) {
                coordinates2 = coordinates.replicate();
                try {
                    n4 = 0;
                    while (n4 <= 1) {
                        if (n4 == 1) {
                            n5 = 4;
                            n6 = 8;
                        } else {
                            n5 = 3;
                            n6 = 7;
                        }
                        coordinates2.inc(n, 1, cell.isBlack());
                        cell2 = this.cells[coordinates2.x()][coordinates2.y()];
                        if (!(cell2.piece() != null & cell2.isBlack() == cell.isBlack())) {
                            if (cell2.piece() == null) {
                                cell2.setLighting(n5);
                            } else {
                                cell2.setLighting(n6);
                            }
                        }
                        ++n4;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.exc = arrayIndexOutOfBoundsException;
                }
            }
            ++n;
        }
        if (piece.getLionPower()) {
            this.lightLion(coordinates.x(), coordinates.y());
        }
    }

    public void lightLion(int n, int n2) {
        Cell cell = null;
        int n3 = 0;
        int n4 = 0;
        Cell cell2 = null;
        cell = this.cells[n][n2];
        int n5 = n2 + 2;
        n3 = n2 - 2;
        while (n3 <= n5) {
            int n6 = n + 2;
            n4 = n - 2;
            while (n4 <= n6) {
                if (n3 == n2 & n4 == n) {
                    cell.setLighting(0);
                } else if (Math.abs(n3 - n2) < 2 & Math.abs(n4 - n) < 2) {
                    try {
                        cell2 = this.cells[n4][n3];
                        if (cell2.piece() == null) {
                            cell2.setLighting(3);
                        } else if (cell2.isBlack() != cell.isBlack()) {
                            cell2.setLighting(7);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        this.exc = arrayIndexOutOfBoundsException;
                    }
                } else {
                    try {
                        cell2 = this.cells[n4][n3];
                        if (cell2.piece() == null) {
                            cell2.setLighting(4);
                        } else if (cell2.isBlack() != cell.isBlack()) {
                            cell2.setLighting(8);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        this.exc = arrayIndexOutOfBoundsException;
                    }
                }
                ++n4;
            }
            ++n3;
        }
    }

    public void setInfluence(Coordinates coordinates, boolean bl, boolean bl2, boolean bl3) {
        Cell cell = null;
        Cell cell2 = null;
        int n = 0;
        int n2 = 0;
        PieceRepresentation pieceRepresentation = null;
        Piece piece = null;
        int n3 = 0;
        int n4 = 0;
        Coordinates coordinates2 = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        n = 0;
        while (n <= 11) {
            n2 = 11;
            while (n2 >= 0) {
                if (!(n == coordinates.y() & n2 == coordinates.x()) && (pieceRepresentation = (cell = this.cells[n2][n]).piece()) != null) {
                    piece = pieceRepresentation.getPiece();
                    if (!bl | cell.isBlack() == bl2) {
                        n3 = 0;
                        while (n3 <= 7) {
                            n4 = piece.getRange(n3);
                            coordinates2 = new Coordinates(new Point(n2, n));
                            try {
                                int n10 = n4;
                                while (n10 > 0) {
                                    coordinates2.inc(n3, 1, cell.isBlack());
                                    cell2 = this.cells[coordinates2.x()][coordinates2.y()];
                                    if (coordinates2.equals(coordinates)) {
                                        if (bl3 == cell.isBlack()) {
                                            cell.setLighting(5);
                                        } else {
                                            cell.setLighting(1);
                                        }
                                        throw new ArrayIndexOutOfBoundsException();
                                    }
                                    if (bl && cell2.piece() != null) {
                                        throw new ArrayIndexOutOfBoundsException();
                                    }
                                    --n10;
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                this.exc = arrayIndexOutOfBoundsException;
                            }
                            if ((piece.getJump(n3) ? 1 : 0) > 0) {
                                try {
                                    coordinates2 = new Coordinates(new Point(n2, n));
                                    coordinates2.inc(n3, 2, cell.isBlack());
                                    this.tempCell = this.cells[coordinates2.x()][coordinates2.y()];
                                    if (coordinates2.equals(coordinates)) {
                                        if (bl3 == cell.isBlack()) {
                                            cell.setLighting(6);
                                        } else {
                                            cell.setLighting(2);
                                        }
                                        throw new ArrayIndexOutOfBoundsException();
                                    }
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    this.exc = arrayIndexOutOfBoundsException;
                                }
                            }
                            if (piece.getLion(n3)) {
                                coordinates2 = new Coordinates(new Point(n2, n));
                                try {
                                    n5 = 0;
                                    while (n5 <= 1) {
                                        coordinates2.inc(n3, 1, cell.isBlack());
                                        if (n5 == 1) {
                                            n6 = 4;
                                            n7 = 8;
                                        } else {
                                            n6 = 3;
                                            n7 = 7;
                                        }
                                        this.tempCell = this.cells[coordinates2.x()][coordinates2.y()];
                                        if (coordinates2.equals(coordinates)) {
                                            if (bl3 == cell.isBlack()) {
                                                cell.setLighting(n7);
                                            } else {
                                                cell.setLighting(n6);
                                            }
                                        }
                                        ++n5;
                                    }
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    this.exc = arrayIndexOutOfBoundsException;
                                }
                            }
                            ++n3;
                        }
                        if (piece.getLionPower()) {
                            int n11 = n + 2;
                            n8 = n - 2;
                            while (n8 <= n11) {
                                int n12 = n2 + 2;
                                n9 = n2 - 2;
                                while (n9 <= n12) {
                                    block41: {
                                        coordinates2 = new Coordinates(new Point(n9, n8));
                                        if (!(n8 == n & n9 == n2)) {
                                            if (Math.abs(n8 - n) < 2 & Math.abs(n9 - n2) < 2) {
                                                try {
                                                    this.tempCell = this.cells[n9][n8];
                                                    if (!coordinates.equals(coordinates2)) break block41;
                                                    if (bl3 == cell.isBlack()) {
                                                        cell.setLighting(7);
                                                        break block41;
                                                    }
                                                    cell.setLighting(3);
                                                }
                                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                                    this.exc = arrayIndexOutOfBoundsException;
                                                }
                                            } else {
                                                try {
                                                    this.tempCell = this.cells[n9][n8];
                                                    if (coordinates.equals(coordinates2)) {
                                                        if (bl3 == cell.isBlack()) {
                                                            cell.setLighting(8);
                                                        } else {
                                                            cell.setLighting(4);
                                                        }
                                                    }
                                                }
                                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                                    this.exc = arrayIndexOutOfBoundsException;
                                                }
                                            }
                                        }
                                    }
                                    ++n9;
                                }
                                ++n8;
                            }
                        }
                    }
                }
                --n2;
            }
            ++n;
        }
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public boolean isLegal(Move move, Move move2) {
        Coordinates coordinates = null;
        Cell cell = null;
        int n = 0;
        Coordinates coordinates2 = null;
        Cell cell2 = null;
        PieceRepresentation pieceRepresentation = null;
        boolean bl = false;
        coordinates = move.getDestination();
        move.setAnotherMovePossible(false);
        cell = this.cells[coordinates.x()][coordinates.y()];
        n = cell.getLighting();
        if (n == 3 & !move.isPending()) {
            move.setAnotherMovePossible(true);
        }
        if (n == 7 & !move.isPending()) {
            move.setAnotherMovePossible(true);
        }
        if (n == 0 | n == 9) {
            return false;
        }
        if (move.isLionTarget()) {
            if (move.isLionSource()) {
                if (move.squares() < 2) {
                    if (n == 7) {
                        return true;
                    }
                    if (n != 8) {
                        JOptionPane.showMessageDialog(null, "Should be a Lion B Capture", "Invariant Violation", 2);
                    }
                    coordinates2 = move.getSource();
                    cell2 = this.cells[coordinates2.x()][coordinates2.y()];
                    pieceRepresentation = cell2.piece();
                    cell2.reset();
                    bl = this.isSquareUnprotected(coordinates, !move.isBlack(), !move.isBlack());
                    cell2.set(pieceRepresentation);
                    if (!bl & move.isInteractive()) {
                        JOptionPane.showMessageDialog(null, "Illegal move - Lion is protected", "Illegal Move", 2);
                    }
                    return bl;
                }
                if (move.isDoubleCapture()) {
                    return true;
                }
                coordinates2 = move.getSource();
                cell2 = this.cells[coordinates2.x()][coordinates2.y()];
                pieceRepresentation = cell2.piece();
                cell2.reset();
                bl = this.isSquareUnprotected(coordinates, !move.isBlack(), !move.isBlack());
                cell2.set(pieceRepresentation);
                if (!bl & move.isInteractive()) {
                    JOptionPane.showMessageDialog(null, "Illegal second move - Lion is protected and not a Double Capture", "Illegal Move", 2);
                }
                return bl;
            }
            if (move2.wasLionCaptured()) {
                if (move.isInteractive()) {
                    JOptionPane.showMessageDialog(null, "Illegal move - Lion was captured last move", "Illegal Move", 2);
                }
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean isSquareUnprotected(Coordinates coordinates, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = 0;
        Cell cell = null;
        boolean bl3 = false;
        Board board = null;
        board = this.replicate();
        bl3 = false;
        board.cells[coordinates.x()][coordinates.y()].reset();
        board.clearLighting();
        board.setInfluence(coordinates, true, bl, bl2);
        n = 0;
        while (n <= 11) {
            n2 = 11;
            while (n2 >= 0) {
                if (!bl3 & (cell = board.cells[n2][n]).getLighting() != 0) {
                    bl3 = true;
                }
                --n2;
            }
            ++n;
        }
        board = null;
        return !bl3;
    }

    public void incrementCrownPrinces(boolean bl) {
        this.crownPrinces[bl ? 1 : 0] = (byte)(this.crownPrinces[bl ? 1 : 0] + 1);
    }

    public void decrementCrownPrinces(boolean bl) {
        this.crownPrinces[bl ? 1 : 0] = (byte)(this.crownPrinces[bl ? 1 : 0] - 1);
    }

    public void adjustCPsAfterCapture(PieceRepresentation pieceRepresentation) {
        Piece piece = null;
        boolean bl = false;
        piece = pieceRepresentation.getPiece();
        bl = pieceRepresentation.isBlack();
        if (piece.isCrownPrince()) {
            this.decrementCrownPrinces(bl);
        }
        this.decrementPiecesOnBoard(bl);
    }

    public void adjustCPsAfterRestoration(PieceRepresentation pieceRepresentation) {
        Piece piece = null;
        boolean bl = false;
        piece = pieceRepresentation.getPiece();
        bl = pieceRepresentation.isBlack();
        if (piece.isCrownPrince()) {
            this.incrementCrownPrinces(bl);
        }
        this.incrementPiecesOnBoard(bl);
    }

    public void adjustCPsAfterPromotion(PieceRepresentation pieceRepresentation) {
        Piece piece = null;
        boolean bl = false;
        piece = pieceRepresentation.getPiece();
        bl = pieceRepresentation.isBlack();
        if (piece.isCrownPrince()) {
            this.incrementCrownPrinces(bl);
        }
    }

    public void adjustCPsBeforeDemotion(PieceRepresentation pieceRepresentation) {
        Piece piece = null;
        boolean bl = false;
        piece = pieceRepresentation.getPiece();
        bl = pieceRepresentation.isBlack();
        if (piece.isCrownPrince()) {
            this.decrementCrownPrinces(bl);
        }
    }

    public void incrementPiecesOnBoard(boolean bl) {
        this.piecesOnBoard[bl ? 1 : 0] = (byte)(this.piecesOnBoard[bl ? 1 : 0] + 1);
    }

    public void decrementPiecesOnBoard(boolean bl) {
        this.piecesOnBoard[bl ? 1 : 0] = (byte)(this.piecesOnBoard[bl ? 1 : 0] - 1);
    }

    public void hornedFalcon(Move move) {
        Coordinates coordinates = null;
        Coordinates coordinates2 = null;
        int n = 0;
        Cell cell = null;
        move.setAnotherMovePossible(false);
        coordinates = move.getStage1();
        coordinates2 = move.getSource();
        n = coordinates2.y();
        if (!(coordinates.x() < 0 | coordinates.x() > 11 | coordinates.y() < 0 | coordinates.y() > 10)) {
            cell = this.cells[coordinates.x()][coordinates.y() + 1];
            if (cell.piece() == null) {
                if (move.wasFirstCaptured()) {
                    cell.setLighting(3);
                } else if (n == coordinates.y() + 1) {
                    cell.setLighting(3);
                } else {
                    cell.setLighting(0);
                }
            } else if (cell.isBlack() == move.isBlack()) {
                cell.setLighting(0);
            } else if (move.wasFirstCaptured()) {
                cell.setLighting(7);
            } else {
                cell.setLighting(0);
            }
        }
        if (!(coordinates.x() < 0 | coordinates.x() > 11 | coordinates.y() < 0 | coordinates.y() > 12)) {
            cell = this.cells[coordinates.x()][coordinates.y() - 1];
            if (cell.piece() == null) {
                if (move.wasFirstCaptured()) {
                    cell.setLighting(3);
                } else if (n == coordinates.y() - 1) {
                    cell.setLighting(3);
                } else {
                    cell.setLighting(0);
                }
            } else if (cell.isBlack() == move.isBlack()) {
                cell.setLighting(0);
            } else if (move.wasFirstCaptured()) {
                cell.setLighting(7);
            } else {
                cell.setLighting(0);
            }
        }
    }

    public void soaringEagle(Move move) {
        Coordinates coordinates = null;
        Coordinates coordinates2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Cell cell = null;
        move.setAnotherMovePossible(false);
        coordinates = move.getStage1();
        coordinates2 = move.getSource();
        n3 = coordinates.x();
        n4 = coordinates.y();
        n = coordinates2.x();
        n2 = coordinates2.y();
        if (n > n3) {
            if (n2 > n4) {
                n5 = n3 - 1;
                n6 = n4 - 1;
            } else {
                n5 = n3 - 1;
                n6 = n4 + 1;
            }
        } else if (n2 > n4) {
            n5 = n3 + 1;
            n6 = n4 - 1;
        } else {
            n5 = n3 + 1;
            n6 = n4 + 1;
        }
        if (!(n5 < 0 | n5 > 11 | n6 < 0 | n6 > 11)) {
            cell = this.cells[n5][n6];
            if (cell.piece() == null) {
                if (move.wasFirstCaptured()) {
                    cell.setLighting(3);
                } else {
                    cell.setLighting(0);
                }
            } else if (cell.isBlack() == move.isBlack()) {
                cell.setLighting(0);
            } else if (move.wasFirstCaptured()) {
                cell.setLighting(7);
            } else {
                cell.setLighting(0);
            }
        }
        if (n > n3) {
            if (n2 > n4) {
                n5 = n3 + 1;
                n6 = n4 + 1;
            } else {
                n5 = n3 + 1;
                n6 = n4 - 1;
            }
        } else if (n2 > n4) {
            n5 = n3 - 1;
            n6 = n4 + 1;
        } else {
            n5 = n3 - 1;
            n6 = n4 - 1;
        }
        if (!(n5 < 0 | n5 > 11 | n6 < 0 | n6 > 11)) {
            cell = this.cells[n5][n6];
            cell.setLighting(3);
        }
    }

    public void lionMove2(Move move) {
        Coordinates coordinates = null;
        Coordinates coordinates2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Cell cell = null;
        int n5 = 0;
        int n6 = 0;
        coordinates = move.getStage1();
        coordinates2 = move.getSource();
        move.setAnotherMovePossible(false);
        n3 = coordinates.x();
        n4 = coordinates.y();
        n = coordinates2.x();
        n2 = coordinates2.y();
        int n7 = n4 + 1;
        n6 = n4 - 1;
        while (n6 <= n7) {
            if (!(n6 < 0 | n6 > 11)) {
                int n8 = n3 + 1;
                n5 = n3 - 1;
                while (n5 <= n8) {
                    if (!(n6 == n4 & n5 == n3) && !(n5 < 0 | n5 > 11)) {
                        cell = this.cells[n5][n6];
                        if (cell.piece() == null) {
                            if (move.wasFirstCaptured()) {
                                cell.setLighting(3);
                            } else if (n5 == n & n6 == n2) {
                                cell.setLighting(3);
                            } else {
                                cell.setLighting(0);
                            }
                        } else if (cell.isBlack() == move.isBlack()) {
                            cell.setLighting(0);
                        } else if (move.wasFirstCaptured()) {
                            cell.setLighting(7);
                        } else {
                            cell.setLighting(0);
                        }
                    }
                    ++n5;
                }
            }
            ++n6;
        }
    }

    public String forsyth() {
        return this.forsyth(false, false);
    }

    public String forsyth(boolean bl) {
        return this.forsyth(bl, false);
    }

    public String forsyth(boolean bl, boolean bl2) {
        String string = null;
        boolean bl3 = false;
        Cell cell = null;
        PieceRepresentation pieceRepresentation = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        string = "/";
        string2 = bl ? "/" + System.getProperty("line.separator") : "/";
        n3 = 0;
        while (n3 <= 11) {
            n = 0;
            bl3 = false;
            n2 = 11;
            while (n2 >= 0) {
                cell = this.cells[n2][n3];
                pieceRepresentation = cell.piece();
                if (pieceRepresentation == null) {
                    ++n;
                    if (n2 == 0) {
                        if (bl3) {
                            string = string + ",";
                        }
                        string = string + new Integer(n).toString();
                        string = string + string2;
                    }
                } else {
                    string3 = pieceRepresentation.isBlack() ? pieceRepresentation.getAbbrev().toLowerCase() : pieceRepresentation.getAbbrev().toUpperCase();
                    if (!(!bl2 || string3.startsWith("+") || string3.equalsIgnoreCase("K") || string3.equalsIgnoreCase("LN") || string3.equalsIgnoreCase("FK"))) {
                        string4 = new Integer(pieceRepresentation.wasDelayed() ? 1 : 0).toString();
                        string5 = new Integer(pieceRepresentation.isOK() ? 1 : 0).toString();
                        string3 = string3 + string4 + string5;
                    }
                    if (bl3) {
                        string = string + ",";
                    }
                    if (n > 0) {
                        string = string + new Integer(n).toString() + ",";
                        n = 0;
                    }
                    string = string + string3;
                    bl3 = true;
                    if (n2 == 0) {
                        string = string + string2;
                    }
                }
                --n2;
            }
            ++n3;
        }
        return string;
    }

    public boolean onlyPieceIsGold(boolean bl) {
        Cell cell = null;
        int n = 0;
        int n2 = 0;
        PieceRepresentation pieceRepresentation = null;
        String string = null;
        n2 = 0;
        while (n2 <= 11) {
            n = 11;
            while (n >= 0) {
                cell = this.cells[n][n2];
                pieceRepresentation = cell.piece();
                if (pieceRepresentation != null && pieceRepresentation.isBlack() == bl && !(string = pieceRepresentation.getAbbrev()).equals("K") && !string.equals("+DE")) {
                    return string.equals("G");
                }
                --n;
            }
            ++n2;
        }
        return false;
    }

    public boolean addPosition(boolean bl) {
        return this.positions[bl ? 1 : 0].add(this.forsyth());
    }

    public void restorePosition(boolean bl) {
        this.positions[bl ? 1 : 0].remove(this.forsyth());
    }

    public void clear(Coordinates coordinates) {
        this.cells[coordinates.x()][coordinates.y()].reset();
        this.piecesOnBoard[0] = 0;
        this.piecesOnBoard[1] = 0;
        this.crownPrinces[0] = 0;
        this.crownPrinces[1] = 0;
    }

    public void clear() {
        int n = 0;
        int n2 = 0;
        n = 0;
        while (n <= 11) {
            n2 = 0;
            while (n2 <= 11) {
                this.cells[n2][n].reset();
                ++n2;
            }
            ++n;
        }
    }

    public void set(Coordinates coordinates, PieceRepresentation pieceRepresentation) {
        this.cells[coordinates.x()][coordinates.y()].set(pieceRepresentation);
    }

    public PiecesData getPieces() {
        return this.piecesData;
    }

    public int getCrownPrinces(boolean bl) {
        return this.crownPrinces[bl ? 1 : 0];
    }

    public int getPiecesOnBoard(boolean bl) {
        return this.piecesOnBoard[bl ? 1 : 0];
    }

    public boolean performMove(Move move, TwoTargets twoTargets) {
        byte by = 0;
        Coordinates coordinates = null;
        Cell cell = null;
        Coordinates coordinates2 = null;
        Cell cell2 = null;
        PieceRepresentation pieceRepresentation = null;
        Coordinates coordinates3 = null;
        Cell cell3 = null;
        PieceRepresentation pieceRepresentation2 = null;
        PieceRepresentation pieceRepresentation3 = null;
        boolean bl = false;
        by = move.squares();
        if (move.wasPassOrIgui()) {
            if (move.wasFirstCaptured()) {
                coordinates = move.getStage1();
                cell = this.cells[coordinates.x()][coordinates.y()];
                pieceRepresentation3 = cell.piece();
                twoTargets.setTarget(pieceRepresentation3);
                this.adjustCPsAfterCapture(pieceRepresentation3);
                cell.reset();
                bl = this.addPosition(move.isBlack());
                return bl;
            }
            bl = this.addPosition(move.isBlack());
            return bl;
        }
        coordinates2 = move.getSource();
        cell2 = this.cells[coordinates2.x()][coordinates2.y()];
        pieceRepresentation = cell2.piece();
        twoTargets.setSource(pieceRepresentation);
        coordinates = move.getStage1();
        cell = this.cells[coordinates.x()][coordinates.y()];
        pieceRepresentation3 = cell.piece();
        if (move.wasFirstCaptured()) {
            twoTargets.setTarget(pieceRepresentation3);
            this.adjustCPsAfterCapture(pieceRepresentation3);
            cell.reset();
        }
        if (by == 2) {
            coordinates3 = move.getStage2();
            cell3 = this.cells[coordinates3.x()][coordinates3.y()];
            pieceRepresentation2 = cell3.piece();
            if (move.wasSecondCaptured()) {
                twoTargets.setTarget2(pieceRepresentation2);
                this.adjustCPsAfterCapture(pieceRepresentation2);
            }
            cell3.set(pieceRepresentation);
        } else {
            if (move.wasPromoted()) {
                pieceRepresentation.promote(this.piecesData.accessPieces());
                this.adjustCPsAfterPromotion(pieceRepresentation);
            }
            cell.set(pieceRepresentation);
        }
        cell2.reset();
        if (move.isOK()) {
            pieceRepresentation.setOK(true);
        }
        if (move.wasDelayed()) {
            pieceRepresentation.setDelayed(true);
        }
        bl = this.addPosition(move.isBlack());
        return bl;
    }

    public void backOutMove(Move move, PieceRepresentation pieceRepresentation, PieceRepresentation pieceRepresentation2, PieceRepresentation pieceRepresentation3) {
        Coordinates coordinates = null;
        Cell cell = null;
        Coordinates coordinates2 = null;
        Cell cell2 = null;
        Coordinates coordinates3 = null;
        Cell cell3 = null;
        byte by = 0;
        this.restorePosition(move.isBlack());
        by = move.squares();
        if (move.wasPassOrIgui()) {
            if (move.wasFirstCaptured()) {
                coordinates2 = move.getStage1();
                cell2 = this.cells[coordinates2.x()][coordinates2.y()];
                this.adjustCPsAfterRestoration(pieceRepresentation2);
                cell2.set(pieceRepresentation2);
            }
            return;
        }
        coordinates2 = move.getStage1();
        cell2 = this.cells[coordinates2.x()][coordinates2.y()];
        if (move.wasPromoted()) {
            this.adjustCPsBeforeDemotion(pieceRepresentation);
        } else if (by == 2) {
            coordinates3 = move.getStage2();
            cell3 = this.cells[coordinates3.x()][coordinates3.y()];
            if (move.wasSecondCaptured()) {
                this.adjustCPsAfterRestoration(pieceRepresentation3);
                cell3.set(pieceRepresentation3);
            } else {
                cell3.reset();
            }
        }
        if (move.wasFirstCaptured()) {
            this.adjustCPsAfterRestoration(pieceRepresentation2);
            cell2.set(pieceRepresentation2);
        } else {
            cell2.reset();
        }
        coordinates = move.getSource();
        cell = this.cells[coordinates.x()][coordinates.y()];
        cell.set(pieceRepresentation);
    }

    public void parseForsyth(String string, boolean bl) {
        int n = 0;
        int n2 = 0;
        char c = '\u0000';
        boolean bl2 = false;
        int n3 = 0;
        String string2 = null;
        int n4 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        Piece piece = null;
        PieceRepresentation pieceRepresentation = null;
        String string3 = null;
        n = -1;
        bl2 = false;
        boolean bl7 = true;
        while (true) {
            if (bl7) {
                bl7 = false;
            } else if (bl2) break;
            c = string.charAt(0);
            if (c == '/') {
                if (++n == 12) {
                    bl2 = true;
                    continue;
                }
                n2 = 11;
                string = string.substring(1);
                continue;
            }
            if (Character.isDigit(c)) {
                if (Character.isDigit(string.charAt(1))) {
                    n3 = new Integer(string.substring(0, 2));
                    string = string.substring(2);
                } else {
                    n3 = new Integer(string.substring(0, 1));
                    string = string.substring(1);
                }
                n2 -= n3;
                continue;
            }
            if (c == ',') {
                string = string.substring(1);
                continue;
            }
            n4 = string.indexOf(",");
            n4 = n4 == -1 ? string.indexOf("/") : Math.min(n4, string.indexOf("/"));
            string2 = string.substring(0, n4);
            string = string.substring(n4);
            bl3 = false;
            if (bl) {
                bl3 = true;
                if (string2.charAt(0) == '+') {
                    bl3 = false;
                } else if (string2.equalsIgnoreCase("K")) {
                    bl3 = false;
                } else if (string2.equalsIgnoreCase("LN")) {
                    bl3 = false;
                } else if (string2.equalsIgnoreCase("FK")) {
                    bl3 = false;
                }
            }
            bl5 = false;
            bl4 = false;
            if (bl3) {
                bl5 = string2.charAt(string2.length() - 1) == '1';
                bl4 = string2.charAt(string2.length() - 2) == '1';
                string2 = string2.substring(0, string2.length() - 2);
            }
            bl6 = string2.equals(string2.toLowerCase());
            string3 = Piece.getName(string2);
            piece = (Piece)this.piecesData.accessPieces().get(string3);
            pieceRepresentation = new PieceRepresentation(piece, bl6);
            pieceRepresentation.setOK(bl5);
            pieceRepresentation.setDelayed(bl4);
            this.cells[n2][n].set(pieceRepresentation);
            this.piecesOnBoard[bl6 ? 1 : 0] = (byte)(this.piecesOnBoard[bl6 ? 1 : 0] + 1);
            if (piece.isCrownPrince()) {
                this.crownPrinces[bl6 ? 1 : 0] = (byte)(this.crownPrinces[bl6 ? 1 : 0] + 1);
            }
            --n2;
        }
    }
}

